/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.IOException;
import java.io.Writer;

public final class JSourceWriter
extends Writer {
    public static final char DEFAULT_CHAR = ' ';
    public static final short DEFAULT_SIZE = 4;
    private String _lineSeparator = System.getProperty("line.separator");
    private boolean _addIndentation = true;
    private boolean _autoflush = false;
    private short _tabSize = (short)4;
    private char[] _tab;
    private char _tabChar = (char)32;
    private short _tabLevel = 0;
    private Writer _out = null;

    public JSourceWriter(Writer out) {
        this(out, 4, ' ', false);
    }

    public JSourceWriter(Writer out, boolean autoflush) {
        this(out, 4, ' ', autoflush);
    }

    public JSourceWriter(Writer out, short tabSize, boolean autoflush) {
        this(out, tabSize, ' ', autoflush);
    }

    public JSourceWriter(Writer out, short tabSize, char tabChar, boolean autoflush) {
        this._out = out;
        this._autoflush = autoflush;
        this._tabChar = tabChar;
        this._tabSize = tabSize;
        this.createTab();
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public void indent() {
        this._tabLevel = (short)(this._tabLevel + 1);
    }

    public boolean isNewline() {
        return this._addIndentation;
    }

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    public void unindent() {
        if (this._tabLevel > 0) {
            this._tabLevel = (short)(this._tabLevel - 1);
        }
    }

    protected short getIndentLevel() {
        return this._tabLevel;
    }

    protected short getIndentSize() {
        return (short)(this._tabLevel * this._tabSize);
    }

    protected char getIndentChar() {
        return this._tabChar;
    }

    protected void writeIndent() {
        try {
            for (int i = 0; i < this._tabLevel; ++i) {
                this._out.write(this._tab);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureIndent() {
        if (this._addIndentation) {
            this.writeIndent();
            this._addIndentation = false;
        }
    }

    private void linefeed() {
        try {
            this._out.write(this._lineSeparator);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createTab() {
        this._tab = new char[this._tabSize];
        for (int i = 0; i < this._tabSize; ++i) {
            this._tab[i] = this._tabChar;
        }
    }

    public void write(float f) {
        this.write(String.valueOf(f));
    }

    public void write(long l) {
        this.write(String.valueOf(l));
    }

    public void write(double d) {
        this.write(String.valueOf(d));
    }

    public void write(Object obj) {
        this.write(obj.toString());
    }

    public void write(boolean b) {
        this.write(String.valueOf(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln() {
        Object object = this.lock;
        synchronized (object) {
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(String.valueOf(f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(String.valueOf(l));
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(int i) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(String.valueOf(i));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(String.valueOf(d));
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(obj.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (string.length() > 0) {
                this.ensureIndent();
                try {
                    this._out.write(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(char[] chars) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(chars);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(String.valueOf(b));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this._addIndentation = true;
        }
    }

    public void close() {
        try {
            this._out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this._out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(s, off, len);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (this._autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this._out.write(buf, off, len);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (this._autoflush) {
                this.flush();
            }
        }
    }
}

