/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.property.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.property.EgovPropertyService;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class EgovPropertyServiceImpl
implements EgovPropertyService,
ApplicationContextAware,
InitializingBean,
DisposableBean,
ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovPropertyServiceImpl.class);
    private ExtendedProperties egovProperties = null;
    private ResourceLoader resourceLoader = null;
    private MessageSource messageSource;
    private Set<?> extFileName;
    private Map<?, ?> properties;

    @Override
    public boolean getBoolean(String name) {
        return this.getConfiguration().getBoolean(name);
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        return this.getConfiguration().getBoolean(name, def);
    }

    @Override
    public double getDouble(String name) {
        return this.getConfiguration().getDouble(name);
    }

    @Override
    public double getDouble(String name, double def) {
        return this.getConfiguration().getDouble(name, def);
    }

    @Override
    public float getFloat(String name) {
        return this.getConfiguration().getFloat(name);
    }

    @Override
    public float getFloat(String name, float def) {
        return this.getConfiguration().getFloat(name, def);
    }

    @Override
    public int getInt(String name) {
        return this.getConfiguration().getInt(name);
    }

    @Override
    public int getInt(String name, int def) {
        return this.getConfiguration().getInt(name, def);
    }

    @Override
    public Iterator<?> getKeys() {
        return this.getConfiguration().getKeys();
    }

    @Override
    public Iterator<?> getKeys(String prefix) {
        return this.getConfiguration().getKeys(prefix);
    }

    @Override
    public long getLong(String name) {
        return this.getConfiguration().getLong(name);
    }

    @Override
    public long getLong(String name, long def) {
        return this.getConfiguration().getLong(name, def);
    }

    @Override
    public String getString(String name) {
        return this.getConfiguration().getString(name);
    }

    @Override
    public String getString(String name, String def) {
        return this.getConfiguration().getString(name, def);
    }

    @Override
    public String[] getStringArray(String name) {
        return this.getConfiguration().getStringArray(name);
    }

    @Override
    public Vector<?> getVector(String name) {
        return this.getConfiguration().getVector(name);
    }

    @Override
    public Vector<?> getVector(String name, Vector<?> def) {
        return this.getConfiguration().getVector(name, def);
    }

    public Collection<String> getAllKeyValue() {
        return this.getConfiguration().values();
    }

    private ExtendedProperties getConfiguration() {
        return this.egovProperties;
    }

    @Override
    public void refreshPropertyFiles() throws FdlException {
        String fileName = null;
        try {
            Iterator<?> it = this.extFileName.iterator();
            while (it != null && it.hasNext()) {
                Object element = it.next();
                String enc = null;
                if (element instanceof Map) {
                    Map ele = (Map)element;
                    enc = (String)ele.get("encoding");
                    fileName = (String)ele.get("filename");
                } else {
                    fileName = (String)element;
                }
                this.loadPropertyResources(fileName, enc);
            }
        }
        catch (Exception e) {
            LOGGER.error(this.messageSource.getMessage("error.properties.refresh.files", (Object[])new String[]{fileName}, Locale.getDefault()));
            LOGGER.error(this.messageSource.getMessage("error.properties.refresh.files.reason", (Object[])new String[0], Locale.getDefault()));
            throw new FdlException("error.properties.refresh.files", (Object[])new String[]{fileName}, (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws FdlException {
        try {
            this.egovProperties = new ExtendedProperties();
            if (this.extFileName != null) {
                this.refreshPropertyFiles();
            }
            for (Map.Entry<?, ?> entry : this.properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                LOGGER.debug(this.messageSource.getMessage("debug.properties.property", (Object[])new String[]{key, value}, Locale.getDefault()));
                if (key == null || key.equals("")) {
                    LOGGER.error(this.messageSource.getMessage("error.properties.check.essential", (Object[])new String[0], Locale.getDefault()));
                    throw new FdlException(this.messageSource, "error.properties.check.essential", null);
                }
                this.egovProperties.put((Object)key, (Object)value);
            }
        }
        catch (Exception e) {
            if (e instanceof FdlException) {
                throw (FdlException)e;
            }
            LOGGER.error(this.messageSource.getMessage("error.properties.initialize.reason", (Object[])new String[0], Locale.getDefault()));
            throw new FdlException(this.messageSource, "error.properties.initialize", (Throwable)e);
        }
    }

    public void setExtFileName(Set<?> extFileName) {
        this.extFileName = extFileName;
    }

    public void setProperties(Map<?, ?> properties) {
        this.properties = properties;
    }

    public void destroy() {
        this.egovProperties = null;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    private void loadPropertyResources(String location, String encoding) throws Exception {
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)this.resourceLoader).getResources(location);
                this.loadPropertyLoop(resources, encoding);
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Could not resolve Properties resource pattern [" + location + "]", (Throwable)ex);
            }
        } else {
            Resource resource = this.resourceLoader.getResource(location);
            this.loadPropertyRes(resource, encoding);
        }
    }

    private void loadPropertyLoop(Resource[] resources, String encoding) throws Exception {
        Assert.notNull((Object)resources, (String)"Resource array must not be null");
        for (int i = 0; i < resources.length; ++i) {
            this.loadPropertyRes(resources[i], encoding);
        }
    }

    private void loadPropertyRes(Resource resource, String encoding) throws Exception {
        LOGGER.debug(this.messageSource.getMessage("debug.properties.filename", (Object[])new String[]{resource.getFilename(), encoding}, Locale.getDefault()));
        ExtendedProperties egovProperty = new ExtendedProperties();
        egovProperty.load(resource.getInputStream(), encoding);
        this.egovProperties.combine(egovProperty);
    }
}

