/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.ActionResultExposer;
import org.springframework.webflow.action.ResultEventFactorySelector;
import org.springframework.webflow.engine.ActionExecutor;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class EvaluateAction
extends AbstractAction {
    private Expression expression;
    private ActionResultExposer evaluationResultExposer;
    private ResultEventFactorySelector resultEventFactorySelector = new ResultEventFactorySelector();

    public EvaluateAction(Expression expression, ActionResultExposer evaluationResultExposer) {
        Assert.notNull((Object)expression, (String)"The expression this action should evaluate is required");
        this.expression = expression;
        this.evaluationResultExposer = evaluationResultExposer;
    }

    public void setResultEventFactorySelector(ResultEventFactorySelector factorySelector) {
        this.resultEventFactorySelector = factorySelector;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Object result = this.expression.getValue((Object)context);
        if (result instanceof Action) {
            return ActionExecutor.execute((Action)result, context);
        }
        if (this.evaluationResultExposer != null) {
            this.evaluationResultExposer.exposeResult(result, context);
        }
        return this.resultEventFactorySelector.forResult(result).createResultEvent(this, result, context);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("expression", (Object)this.expression).append("resultExposer", (Object)this.evaluationResultExposer).toString();
    }
}

