/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.io.File;
import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.core.collection.AttributeMap;

public class FlowDefinitionResourceFactory {
    private ResourceLoader resourceLoader;

    public FlowDefinitionResourceFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public FlowDefinitionResourceFactory(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"The resource loader cannot be null");
        this.resourceLoader = resourceLoader;
    }

    public FlowDefinitionResource createResource(String path) {
        return this.createResource(path, null, null);
    }

    public FlowDefinitionResource createResource(String path, AttributeMap attributes) {
        return this.createResource(path, attributes, null);
    }

    public FlowDefinitionResource createResource(String path, AttributeMap attributes, String flowId) {
        Resource resource = this.resourceLoader.getResource(path);
        if (flowId == null || flowId.length() == 0) {
            flowId = this.getFlowId(resource);
        }
        return new FlowDefinitionResource(flowId, resource, attributes);
    }

    public FlowDefinitionResource[] createResources(String pattern) throws IOException {
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            ResourcePatternResolver resolver = (ResourcePatternResolver)this.resourceLoader;
            Resource[] resources = resolver.getResources(pattern);
            FlowDefinitionResource[] flowResources = new FlowDefinitionResource[resources.length];
            int i = 0;
            while (i < resources.length) {
                Resource resource = resources[i];
                flowResources[i] = new FlowDefinitionResource(this.getFlowId(resource), resource, null);
                ++i;
            }
            return flowResources;
        }
        throw new IllegalStateException("Cannot create flow definition resources from patterns without a ResourceLoader configured that is a ResourcePatternResolver");
    }

    public FlowDefinitionResource createFileResource(String path) {
        FileSystemResource resource = new FileSystemResource(new File(path));
        return new FlowDefinitionResource(this.getFlowId((Resource)resource), (Resource)resource, null);
    }

    public FlowDefinitionResource createClassPathResource(String path, Class clazz) {
        ClassPathResource resource = new ClassPathResource(path, clazz);
        return new FlowDefinitionResource(this.getFlowId((Resource)resource), (Resource)resource, null);
    }

    protected String getFlowId(Resource flowResource) {
        String fileName = flowResource.getFilename();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex != -1) {
            return fileName.substring(0, extensionIndex);
        }
        return fileName;
    }
}

