/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.webflow.config.FlowElementAttribute;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.engine.impl.FlowExecutionImplStateRestorer;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.mvc.builder.MvcEnvironment;

class FlowExecutorFactoryBean
implements FactoryBean,
ApplicationContextAware,
InitializingBean {
    private static final String ALWAYS_REDIRECT_ON_PAUSE = "alwaysRedirectOnPause";
    private FlowDefinitionLocator flowDefinitionLocator;
    private Integer maxFlowExecutions;
    private Integer maxFlowExecutionSnapshots;
    private Set flowExecutionAttributes;
    private FlowExecutionListenerLoader flowExecutionListenerLoader;
    private ConversionService conversionService = DefaultConversionService.getSharedInstance();
    private FlowExecutor flowExecutor;
    private MvcEnvironment environment;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    FlowExecutorFactoryBean() {
    }

    public void setFlowDefinitionLocator(FlowDefinitionLocator flowDefinitionLocator) {
        this.flowDefinitionLocator = flowDefinitionLocator;
    }

    public void setMaxFlowExecutions(int maxFlowExecutions) {
        this.maxFlowExecutions = new Integer(maxFlowExecutions);
    }

    public void setMaxFlowExecutionSnapshots(int maxFlowExecutionSnapshots) {
        this.maxFlowExecutionSnapshots = new Integer(maxFlowExecutionSnapshots);
    }

    public void setFlowExecutionAttributes(Set flowExecutionAttributes) {
        this.flowExecutionAttributes = flowExecutionAttributes;
    }

    public void setFlowExecutionListenerLoader(FlowExecutionListenerLoader flowExecutionListenerLoader) {
        this.flowExecutionListenerLoader = flowExecutionListenerLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.environment = MvcEnvironment.environmentFor(applicationContext);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.flowDefinitionLocator, (String)"The flow definition locator property is required");
        MutableAttributeMap executionAttributes = this.createFlowExecutionAttributes();
        DefaultFlowExecutionRepository executionRepository = this.createFlowExecutionRepository(executionAttributes);
        FlowExecutionFactory executionFactory = this.createFlowExecutionFactory(executionAttributes, executionRepository);
        this.flowExecutor = new FlowExecutorImpl(this.flowDefinitionLocator, executionFactory, executionRepository);
    }

    public Class getObjectType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.executor.FlowExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        return this.flowExecutor;
    }

    private MutableAttributeMap createFlowExecutionAttributes() {
        LocalAttributeMap executionAttributes = new LocalAttributeMap();
        if (this.flowExecutionAttributes != null) {
            Iterator it = this.flowExecutionAttributes.iterator();
            while (it.hasNext()) {
                FlowElementAttribute attribute = (FlowElementAttribute)it.next();
                executionAttributes.put(attribute.getName(), this.getConvertedValue(attribute));
            }
        }
        this.putDefaultFlowExecutionAttributes(executionAttributes);
        return executionAttributes;
    }

    private void putDefaultFlowExecutionAttributes(LocalAttributeMap executionAttributes) {
        if (!executionAttributes.contains(ALWAYS_REDIRECT_ON_PAUSE)) {
            if (this.environment == MvcEnvironment.PORTLET) {
                executionAttributes.put(ALWAYS_REDIRECT_ON_PAUSE, Boolean.FALSE);
            } else {
                executionAttributes.put(ALWAYS_REDIRECT_ON_PAUSE, Boolean.TRUE);
            }
        }
    }

    private DefaultFlowExecutionRepository createFlowExecutionRepository(AttributeMap executionAttributes) {
        ConversationManager conversationManager = this.createConversationManager();
        FlowExecutionStateRestorer executionStateRestorer = this.createFlowExecutionStateRestorer(executionAttributes);
        DefaultFlowExecutionRepository repository = new DefaultFlowExecutionRepository(conversationManager, executionStateRestorer);
        if (this.maxFlowExecutionSnapshots != null) {
            repository.setMaxSnapshots(this.maxFlowExecutionSnapshots);
        }
        return repository;
    }

    private ConversationManager createConversationManager() {
        SessionBindingConversationManager conversationManager = new SessionBindingConversationManager();
        if (this.maxFlowExecutions != null) {
            conversationManager.setMaxConversations(this.maxFlowExecutions);
        }
        return conversationManager;
    }

    private FlowExecutionStateRestorer createFlowExecutionStateRestorer(AttributeMap executionAttributes) {
        FlowExecutionImplStateRestorer executionStateRestorer = new FlowExecutionImplStateRestorer(this.flowDefinitionLocator);
        executionStateRestorer.setExecutionAttributes(executionAttributes);
        if (this.flowExecutionListenerLoader != null) {
            executionStateRestorer.setExecutionListenerLoader(this.flowExecutionListenerLoader);
        }
        return executionStateRestorer;
    }

    private FlowExecutionFactory createFlowExecutionFactory(AttributeMap executionAttributes, FlowExecutionKeyFactory keyFactory) {
        FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
        executionFactory.setExecutionAttributes(executionAttributes);
        if (this.flowExecutionListenerLoader != null) {
            executionFactory.setExecutionListenerLoader(this.flowExecutionListenerLoader);
        }
        executionFactory.setExecutionKeyFactory(keyFactory);
        return executionFactory;
    }

    private Object getConvertedValue(FlowElementAttribute attribute) {
        if (attribute.needsTypeConversion()) {
            Class targetType = this.fromStringToClass(attribute.getType());
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ConversionExecutor converter = this.conversionService.getConversionExecutor((Class)clazz, targetType);
            return converter.execute((Object)attribute.getValue());
        }
        return attribute.getValue();
    }

    private Class fromStringToClass(String type) {
        Class<?> clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Class)this.conversionService.getConversionExecutor((Class)clazz2, (Class)clazz).execute((Object)type);
    }
}

