/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.context.servlet.HttpServletContextMap;
import org.springframework.webflow.context.servlet.HttpServletRequestMap;
import org.springframework.webflow.context.servlet.HttpServletRequestParameterMap;
import org.springframework.webflow.context.servlet.HttpSessionMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class ServletExternalContext
implements ExternalContext {
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ParameterMap requestParameterMap;
    private MutableAttributeMap requestMap;
    private SharedAttributeMap sessionMap;
    private SharedAttributeMap applicationMap;
    private boolean flowExecutionRedirectRequested;
    private String flowDefinitionRedirectFlowId;
    private MutableAttributeMap flowDefinitionRedirectFlowInput;
    private String externalRedirectUrl;
    private FlowUrlHandler flowUrlHandler;
    private boolean ajaxRequest;
    private boolean redirectInPopup;

    public ServletExternalContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.init(context, request, response, new DefaultFlowUrlHandler());
    }

    public ServletExternalContext(ServletContext context, HttpServletRequest request, HttpServletResponse response, FlowUrlHandler flowUrlHandler) {
        this.init(context, request, response, flowUrlHandler);
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public MutableAttributeMap getRequestMap() {
        return this.requestMap;
    }

    public SharedAttributeMap getSessionMap() {
        return this.sessionMap;
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.getSessionMap();
    }

    public SharedAttributeMap getApplicationMap() {
        return this.applicationMap;
    }

    public Principal getCurrentUser() {
        return this.request.getUserPrincipal();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Object getNativeContext() {
        return this.context;
    }

    public Object getNativeRequest() {
        return this.request;
    }

    public Object getNativeResponse() {
        return this.response;
    }

    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    public String getFlowExecutionUrl(String flowId, String flowExecutionKey) {
        return this.flowUrlHandler.createFlowExecutionUrl(flowId, flowExecutionKey, this.request);
    }

    public Writer getResponseWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException e) {
            IllegalStateException ise = new IllegalStateException("Unable to access the response Writer");
            ise.initCause(e);
            throw ise;
        }
    }

    public boolean isResponseCommitted() {
        return this.getFlowExecutionRedirectRequested() || this.getFlowDefinitionRedirectRequested() || this.getExternalRedirectRequested();
    }

    public boolean isResponseAllowed() {
        return true;
    }

    public void requestFlowExecutionRedirect() {
        this.flowExecutionRedirectRequested = true;
    }

    public void requestExternalRedirect(String location) {
        this.externalRedirectUrl = location;
    }

    public void requestFlowDefinitionRedirect(String flowId, MutableAttributeMap input) {
        this.flowDefinitionRedirectFlowId = flowId;
        this.flowDefinitionRedirectFlowInput = input;
    }

    public void requestRedirectInPopup() {
        this.redirectInPopup = true;
    }

    public boolean getFlowExecutionRedirectRequested() {
        return this.flowExecutionRedirectRequested;
    }

    public boolean getFlowDefinitionRedirectRequested() {
        return this.flowDefinitionRedirectFlowId != null;
    }

    public String getFlowRedirectFlowId() {
        return this.flowDefinitionRedirectFlowId;
    }

    public MutableAttributeMap getFlowRedirectFlowInput() {
        return this.flowDefinitionRedirectFlowInput;
    }

    public boolean getExternalRedirectRequested() {
        return this.externalRedirectUrl != null;
    }

    public String getExternalRedirectUrl() {
        return this.externalRedirectUrl;
    }

    public boolean getRedirectInPopup() {
        return this.redirectInPopup;
    }

    protected ServletContext getContext() {
        return this.context;
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    protected HttpServletResponse getResponse() {
        return this.response;
    }

    protected FlowUrlHandler getFlowUrlHandler() {
        return this.flowUrlHandler;
    }

    private void init(ServletContext context, HttpServletRequest request, HttpServletResponse response, FlowUrlHandler flowUrlHandler) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.requestParameterMap = new LocalParameterMap((Map)((Object)new HttpServletRequestParameterMap(request)));
        this.requestMap = new LocalAttributeMap((Map)((Object)new HttpServletRequestMap(request)));
        this.sessionMap = new LocalSharedAttributeMap(new HttpSessionMap(request));
        this.applicationMap = new LocalSharedAttributeMap(new HttpServletContextMap(context));
        this.flowUrlHandler = flowUrlHandler;
    }
}

