/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.definition.registry;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;
import org.springframework.webflow.definition.registry.StaticFlowDefinitionHolder;

public class FlowDefinitionRegistryImpl
implements FlowDefinitionRegistry {
    private static final Log logger;
    private Map flowDefinitions = new TreeMap();
    private FlowDefinitionRegistry parent;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.definition.registry.FlowDefinitionRegistryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public FlowDefinition getFlowDefinition(String id) throws NoSuchFlowDefinitionException, FlowDefinitionConstructionException {
        Assert.hasText((String)id, (String)"An id is required to lookup a FlowDefinition");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting FlowDefinition with id '" + id + "'"));
            }
            return this.getFlowDefinitionHolder(id).getFlowDefinition();
        }
        catch (NoSuchFlowDefinitionException e) {
            if (this.parent != null) {
                return this.parent.getFlowDefinition(id);
            }
            throw e;
        }
    }

    public int getFlowDefinitionCount() {
        return this.flowDefinitions.size();
    }

    public String[] getFlowDefinitionIds() {
        return this.flowDefinitions.keySet().toArray(new String[this.flowDefinitions.size()]);
    }

    public FlowDefinitionRegistry getParent() {
        return this.parent;
    }

    public void setParent(FlowDefinitionRegistry parent) {
        this.parent = parent;
    }

    public void registerFlowDefinition(FlowDefinitionHolder definitionHolder) {
        Assert.notNull((Object)definitionHolder, (String)"The holder of the flow definition to register is required");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering flow definition held by " + definitionHolder));
        }
        this.flowDefinitions.put(definitionHolder.getFlowDefinitionId(), definitionHolder);
    }

    public void registerFlowDefinition(FlowDefinition definition) {
        this.registerFlowDefinition(new StaticFlowDefinitionHolder(definition));
    }

    private FlowDefinitionHolder getFlowDefinitionHolder(String id) throws NoSuchFlowDefinitionException {
        FlowDefinitionHolder holder = (FlowDefinitionHolder)this.flowDefinitions.get(id);
        if (holder == null) {
            throw new NoSuchFlowDefinitionException(id);
        }
        return holder;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowDefinitions", (Object)this.flowDefinitions).append("parent", (Object)this.parent).toString();
    }
}

