/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.AnnotatedObject;
import org.springframework.webflow.engine.VariableValueFactory;
import org.springframework.webflow.execution.RequestContext;

public class FlowVariable
extends AnnotatedObject {
    private String name;
    private VariableValueFactory valueFactory;

    public FlowVariable(String name, VariableValueFactory valueFactory) {
        Assert.hasText((String)name, (String)"The variable name is required");
        Assert.notNull((Object)valueFactory, (String)"The variable value factory is required");
        this.name = name;
        this.valueFactory = valueFactory;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlowVariable)) {
            return false;
        }
        FlowVariable other = (FlowVariable)o;
        return this.name.equals(other.name) && this.valueFactory.equals(other.valueFactory);
    }

    public int hashCode() {
        return this.name.hashCode() + this.valueFactory.hashCode();
    }

    public void create(RequestContext context) {
        Object value = this.valueFactory.createInitialValue(context);
        context.getFlowScope().put(this.name, value);
    }

    public void restore(RequestContext context) {
        Object value = context.getFlowScope().get(this.name);
        this.valueFactory.restoreReferences(value, context);
    }

    public Object destroy(RequestContext context) {
        return context.getFlowScope().remove(this.name);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.name).append("valueFactory", (Object)this.valueFactory).toString();
    }
}

