/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageContextFactory;
import org.springframework.binding.message.StateManageableMessageContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.impl.FlowExecutionListeners;
import org.springframework.webflow.engine.impl.FlowSessionImpl;
import org.springframework.webflow.engine.impl.RequestControlContextImpl;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.execution.View;

public class FlowExecutionImpl
implements FlowExecution,
Externalizable {
    private static final Log logger;
    private static final String FLASH_SCOPE_ATTRIBUTE = "flashScope";
    private transient Flow flow;
    private boolean started;
    private LinkedList flowSessions;
    private transient FlowExecutionListeners listeners;
    private transient FlowExecutionKeyFactory keyFactory;
    private transient MessageContextFactory messageContextFactory;
    private transient FlowExecutionKey key;
    private transient MutableAttributeMap conversationScope;
    private transient AttributeMap attributes;
    private String flowId;
    private transient FlowExecutionOutcome outcome;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.engine.impl.FlowExecutionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public FlowExecutionImpl() {
    }

    public FlowExecutionImpl(Flow flow) {
        Assert.notNull((Object)flow, (String)"The flow definition is required");
        this.flow = flow;
        this.listeners = new FlowExecutionListeners();
        this.attributes = CollectionUtils.EMPTY_ATTRIBUTE_MAP;
        this.flowSessions = new LinkedList();
        this.conversationScope = new LocalAttributeMap();
        this.conversationScope.put(FLASH_SCOPE_ATTRIBUTE, new LocalAttributeMap());
    }

    FlowExecutionImpl(String flowId, LinkedList flowSessions) {
        this.flowId = flowId;
        this.flowSessions = flowSessions;
    }

    public String getCaption() {
        return "execution of '" + this.flow.getId() + "'";
    }

    public FlowExecutionKey getKey() {
        return this.key;
    }

    public FlowDefinition getDefinition() {
        return this.flow;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean isActive() {
        return !this.flowSessions.isEmpty();
    }

    public boolean hasEnded() {
        return this.hasStarted() && !this.isActive();
    }

    public FlowExecutionOutcome getOutcome() {
        return this.outcome;
    }

    public FlowSession getActiveSession() {
        if (!this.isActive()) {
            if (this.started) {
                throw new IllegalStateException("No active session to access; this flow execution has ended");
            }
            throw new IllegalStateException("No active session to access; this flow execution has not been started");
        }
        return this.getActiveSessionInternal();
    }

    public MutableAttributeMap getFlashScope() {
        return (MutableAttributeMap)this.conversationScope.get(FLASH_SCOPE_ATTRIBUTE);
    }

    public MutableAttributeMap getConversationScope() {
        return this.conversationScope;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(MutableAttributeMap input, ExternalContext externalContext) throws FlowExecutionException, IllegalStateException {
        block17: {
            block16: {
                Assert.state((boolean)(this.started == false), (String)"This flow has already been started; you cannot call 'start()' more than once");
                if (FlowExecutionImpl.logger.isDebugEnabled()) {
                    FlowExecutionImpl.logger.debug((Object)("Starting execution in " + externalContext));
                }
                this.started = true;
                context = this.createControlContext(externalContext, this.createMessageContext());
                RequestContextHolder.setRequestContext(context);
                this.listeners.fireRequestSubmitted(context);
                try {
                    try {
                        this.start(this.flow, input, context);
                    }
                    catch (FlowExecutionException e) {
                        this.handleException(e, context);
                    }
                    catch (Exception e) {
                        this.handleException(this.wrap(e), context);
                    }
                }
                catch (Throwable var6_6) {
                    var5_7 = null;
                    if (!this.hasEnded()) {
                        this.saveMessages(context);
                        try {
                            this.listeners.firePaused(context);
                        }
                        catch (Throwable e) {
                            FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
                        }
                    }
                    try {
                        this.listeners.fireRequestProcessed(context);
                    }
                    catch (Throwable e) {
                        FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
                    }
                    RequestContextHolder.setRequestContext(null);
                    throw var6_6;
                }
                {
                    var5_8 = null;
                    if (this.hasEnded()) break block16;
                    this.saveMessages(context);
                }
                ** try [egrp 2[TRYBLOCK] [5 : 142->153)] { 
lbl41:
                // 1 sources

                this.listeners.firePaused(context);
                break block16;
lbl43:
                // 1 sources

                catch (Throwable e) {
                    FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
                }
            }
            ** try [egrp 3[TRYBLOCK] [6 : 167->178)] { 
lbl47:
            // 1 sources

            this.listeners.fireRequestProcessed(context);
            break block17;
lbl49:
            // 1 sources

            catch (Throwable e) {
                FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
            }
        }
        RequestContextHolder.setRequestContext(null);
    }

    public void setCurrentState(String stateId) {
        FlowSessionImpl session;
        State state = this.flow.getStateInstance(stateId);
        if (this.started) {
            session = this.getActiveSessionInternal();
        } else {
            session = this.activateSession(this.flow);
            this.started = true;
        }
        session.setCurrentState(state);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resume(ExternalContext externalContext) throws FlowExecutionException, IllegalStateException {
        block18: {
            block17: {
                if (!this.isActive()) {
                    if (this.started == false) throw new IllegalStateException("This flow execution cannot be resumed; it has not been started");
                    throw new IllegalStateException("This flow execution cannot be resumed; it has ended");
                }
                if (FlowExecutionImpl.logger.isDebugEnabled()) {
                    FlowExecutionImpl.logger.debug((Object)("Resuming execution in " + externalContext));
                }
                context = this.createControlContext(externalContext, this.createMessageContext());
                RequestContextHolder.setRequestContext(context);
                this.listeners.fireRequestSubmitted(context);
                try {
                    try {
                        this.listeners.fireResuming(context);
                        this.getActiveSessionInternal().getFlow().resume(context);
                    }
                    catch (FlowExecutionException e) {
                        this.handleException(e, context);
                    }
                    catch (Exception e) {
                        this.handleException(this.wrap(e), context);
                    }
                }
                catch (Throwable var5_5) {
                    var4_6 = null;
                    if (!this.hasEnded()) {
                        this.saveMessages(context);
                        try {
                            this.listeners.firePaused(context);
                        }
                        catch (Throwable e) {
                            FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
                        }
                    }
                    try {
                        this.listeners.fireRequestProcessed(context);
                    }
                    catch (Throwable e) {
                        FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
                    }
                    RequestContextHolder.setRequestContext(null);
                    throw var5_5;
                }
                {
                    var4_7 = null;
                    if (this.hasEnded()) break block17;
                    this.saveMessages(context);
                }
                ** try [egrp 2[TRYBLOCK] [5 : 162->173)] { 
lbl43:
                // 1 sources

                this.listeners.firePaused(context);
                break block17;
lbl45:
                // 1 sources

                catch (Throwable e) {
                    FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
                }
            }
            ** try [egrp 3[TRYBLOCK] [6 : 187->198)] { 
lbl49:
            // 1 sources

            this.listeners.fireRequestProcessed(context);
            break block18;
lbl51:
            // 1 sources

            catch (Throwable e) {
                FlowExecutionImpl.logger.error((Object)"Flow execution listener threw exception", e);
            }
        }
        RequestContextHolder.setRequestContext(null);
    }

    private MessageContext createMessageContext() {
        StateManageableMessageContext messageContext = this.messageContextFactory.createMessageContext();
        Serializable messagesMemento = (Serializable)this.getFlashScope().extract("messagesMemento");
        if (messagesMemento != null) {
            messageContext.restoreMessages(messagesMemento);
        }
        return messageContext;
    }

    private void saveMessages(RequestContext context) {
        Serializable messagesMemento = ((StateManageableMessageContext)context.getMessageContext()).createMessagesMemento();
        this.getFlashScope().put("messagesMemento", messagesMemento);
    }

    protected RequestControlContext createControlContext(ExternalContext externalContext, MessageContext messageContext) {
        return new RequestControlContextImpl(this, externalContext, messageContext);
    }

    protected FlowSessionImpl createFlowSession(Flow flow, FlowSessionImpl parent) {
        return new FlowSessionImpl(flow, parent);
    }

    void start(Flow flow, MutableAttributeMap input, RequestControlContext context) {
        this.listeners.fireSessionCreating(context, flow);
        FlowSessionImpl session = this.activateSession(flow);
        if (input == null) {
            input = new LocalAttributeMap();
        }
        this.listeners.fireSessionStarting(context, session, input);
        flow.start(context, input);
        this.listeners.fireSessionStarted(context, session);
    }

    void setCurrentState(State newState, RequestContext context) {
        this.listeners.fireStateEntering(context, newState);
        FlowSessionImpl session = this.getActiveSessionInternal();
        State previousState = (State)session.getState();
        session.setCurrentState(newState);
        this.listeners.fireStateEntered(context, previousState);
    }

    public void viewRendering(View view, RequestContext context) {
        this.listeners.fireViewRendering(context, view);
    }

    public void viewRendered(View view, RequestContext context) {
        this.listeners.fireViewRendered(context, view);
    }

    boolean handleEvent(Event event, RequestControlContext context) {
        this.listeners.fireEventSignaled(context, event);
        return this.getActiveSessionInternal().getFlow().handleEvent(context);
    }

    boolean execute(Transition transition, RequestControlContext context) {
        this.listeners.fireTransitionExecuting(context, transition);
        return transition.execute(this.getCurrentState(), context);
    }

    void endActiveFlowSession(String outcome, MutableAttributeMap output, RequestControlContext context) {
        FlowSessionImpl session = this.getActiveSessionInternal();
        this.listeners.fireSessionEnding(context, session, outcome, output);
        session.getFlow().end(context, outcome, output);
        this.flowSessions.removeLast();
        boolean executionEnded = this.hasEnded();
        if (executionEnded) {
            this.outcome = new FlowExecutionOutcome(outcome, output);
        }
        this.listeners.fireSessionEnded(context, session, outcome, output);
        if (!executionEnded) {
            this.getActiveSessionInternal().getFlow().restoreVariables(context);
            context.handleEvent(new Event(session.getState(), outcome, output));
        }
    }

    FlowExecutionKey assignKey() {
        this.key = this.keyFactory.getKey(this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Assigned key " + this.key));
        }
        return this.key;
    }

    void updateCurrentFlowExecutionSnapshot() {
        this.keyFactory.updateFlowExecutionSnapshot(this);
    }

    void removeCurrentFlowExecutionSnapshot() {
        this.keyFactory.removeFlowExecutionSnapshot(this);
    }

    void removeAllFlowExecutionSnapshots() {
        this.keyFactory.removeAllFlowExecutionSnapshots(this);
    }

    FlowExecutionListener[] getListeners() {
        return this.listeners.getArray();
    }

    void setListeners(FlowExecutionListener[] listeners) {
        this.listeners = new FlowExecutionListeners(listeners);
    }

    void setAttributes(AttributeMap attributes) {
        this.attributes = attributes;
    }

    void setKeyFactory(FlowExecutionKeyFactory keyFactory) {
        this.keyFactory = keyFactory;
    }

    void setMessageContextFactory(MessageContextFactory messageContextFactory) {
        this.messageContextFactory = messageContextFactory;
    }

    String getFlowId() {
        return this.flowId;
    }

    LinkedList getFlowSessions() {
        return this.flowSessions;
    }

    boolean hasSessions() {
        return !this.flowSessions.isEmpty();
    }

    boolean hasSubflowSessions() {
        return this.flowSessions.size() > 1;
    }

    FlowSessionImpl getRootSession() {
        return (FlowSessionImpl)this.flowSessions.getFirst();
    }

    ListIterator getSubflowSessionIterator() {
        return this.flowSessions.listIterator(1);
    }

    void setFlow(Flow flow) {
        this.flow = flow;
    }

    void setConversationScope(MutableAttributeMap conversationScope) {
        this.conversationScope = conversationScope;
    }

    void setKey(FlowExecutionKey key) {
        this.key = key;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.started = in.readBoolean();
        this.flowId = (String)in.readObject();
        this.flowSessions = (LinkedList)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.started);
        out.writeObject(this.flow.getId());
        out.writeObject(this.flowSessions);
    }

    public String toString() {
        if (!this.isActive()) {
            if (!this.hasStarted()) {
                return "[Not yet started " + this.getCaption() + "]";
            }
            return "[Ended " + this.getCaption() + "]";
        }
        if (this.flow != null) {
            return new ToStringCreator((Object)this).append("flow", (Object)this.flow.getId()).append("flowSessions", (Object)this.flowSessions).toString();
        }
        return "[Unhydrated execution of '" + this.flowId + "']";
    }

    private FlowSessionImpl activateSession(Flow flow) {
        FlowSessionImpl session;
        if (!this.flowSessions.isEmpty()) {
            FlowSessionImpl parent = this.getActiveSessionInternal();
            session = this.createFlowSession(flow, parent);
        } else {
            session = this.createFlowSession(flow, null);
        }
        this.flowSessions.add(session);
        return session;
    }

    private FlowSessionImpl getActiveSessionInternal() {
        return (FlowSessionImpl)this.flowSessions.getLast();
    }

    private FlowExecutionException wrap(Exception e) {
        if (this.isActive()) {
            FlowSession session = this.getActiveSession();
            String flowId = session.getDefinition().getId();
            String stateId = session.getState() != null ? session.getState().getId() : null;
            return new FlowExecutionException(flowId, stateId, "Exception thrown in state '" + stateId + "' of flow '" + flowId + "'", e);
        }
        return new FlowExecutionException(this.flow.getId(), null, "Exception thrown within inactive flow '" + this.flow.getId() + "'", e);
    }

    private void handleException(FlowExecutionException exception, RequestControlContext context) throws FlowExecutionException {
        this.listeners.fireExceptionThrown(context, exception);
        if (logger.isDebugEnabled()) {
            if (exception.getCause() != null) {
                logger.debug((Object)("Attempting to handle [" + exception + "] with root cause [" + this.getRootCause(exception) + "]"));
            } else {
                logger.debug((Object)("Attempting to handle [" + exception + "]"));
            }
        }
        boolean handled = false;
        try {
            if (this.tryStateHandlers(exception, context) || this.tryFlowHandlers(exception, context)) {
                handled = true;
            }
        }
        catch (FlowExecutionException newException) {
            this.handleException(newException, context);
        }
        if (!handled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rethrowing unhandled flow execution exception");
            }
            throw exception;
        }
    }

    private Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        return cause == null ? e : this.getRootCause(cause);
    }

    private boolean tryStateHandlers(FlowExecutionException exception, RequestControlContext context) {
        if (exception.getStateId() != null) {
            return this.getCurrentFlow().getStateInstance(exception.getStateId()).handleException(exception, context);
        }
        return false;
    }

    private boolean tryFlowHandlers(FlowExecutionException exception, RequestControlContext context) {
        return this.getCurrentFlow().handleException(exception, context);
    }

    private Flow getCurrentFlow() {
        if (this.isActive()) {
            return this.getActiveSessionInternal().getFlow();
        }
        return this.flow;
    }

    private State getCurrentState() {
        FlowSessionImpl session = this.getActiveSessionInternal();
        State currentState = (State)session.getState();
        return currentState;
    }
}

