/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.engine.impl.FlowExecutionImplServicesConfigurer;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;

public class FlowExecutionImplFactory
extends FlowExecutionImplServicesConfigurer
implements FlowExecutionFactory {
    private static final Log logger;
    private FlowExecutionKeyFactory executionKeyFactory = new SimpleFlowExecutionKeyFactory();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.engine.impl.FlowExecutionImplFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public void setExecutionKeyFactory(FlowExecutionKeyFactory executionKeyFactory) {
        this.executionKeyFactory = executionKeyFactory;
    }

    public FlowExecution createFlowExecution(FlowDefinition flowDefinition) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.springframework.webflow.engine.Flow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.isInstanceOf((Class)clazz, (Object)flowDefinition, (String)"Flow definition is of wrong type: ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating new execution of '" + flowDefinition.getId() + "'"));
        }
        FlowExecutionImpl execution = new FlowExecutionImpl((Flow)flowDefinition);
        this.configureServices(execution);
        execution.setKeyFactory(this.executionKeyFactory);
        return execution;
    }

    private static class SimpleFlowExecutionKeyFactory
    implements FlowExecutionKeyFactory {
        private int sequence;

        private SimpleFlowExecutionKeyFactory() {
        }

        public FlowExecutionKey getKey(FlowExecution execution) {
            if (execution.getKey() == null) {
                return new SimpleFlowExecutionKey(this.nextSequence());
            }
            return execution.getKey();
        }

        public void removeAllFlowExecutionSnapshots(FlowExecution execution) {
        }

        public void removeFlowExecutionSnapshot(FlowExecution execution) {
        }

        public void updateFlowExecutionSnapshot(FlowExecution execution) {
        }

        private synchronized int nextSequence() {
            return ++this.sequence;
        }

        private static class SimpleFlowExecutionKey
        extends FlowExecutionKey {
            private int value;

            public SimpleFlowExecutionKey(int value) {
                this.value = value;
            }

            public boolean equals(Object o) {
                if (!(o instanceof SimpleFlowExecutionKey)) {
                    SimpleFlowExecutionKey key = (SimpleFlowExecutionKey)o;
                    return this.value == key.value;
                }
                return false;
            }

            public int hashCode() {
                return this.value * 29;
            }

            public String toString() {
                return String.valueOf(this.value);
            }
        }
    }
}

