/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.execution.FlowSession;

class FlowSessionImpl
implements FlowSession,
Externalizable {
    private static final String VIEW_SCOPE_ATTRIBUTE = "viewScope";
    private transient Flow flow;
    private String flowId;
    private transient State state;
    private String stateId;
    private MutableAttributeMap scope = new LocalAttributeMap();
    private FlowSessionImpl parent;

    public FlowSessionImpl() {
    }

    public FlowSessionImpl(Flow flow, FlowSessionImpl parent) {
        Assert.notNull((Object)flow, (String)"The flow is required");
        this.flow = flow;
        this.parent = parent;
    }

    public FlowDefinition getDefinition() {
        return this.flow;
    }

    public StateDefinition getState() {
        return this.state;
    }

    public MutableAttributeMap getScope() {
        return this.scope;
    }

    public MutableAttributeMap getViewScope() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException("The current state of this flow '" + this.flow.getId() + "' is [null] - cannot access view scope");
        }
        if (!this.state.isViewState()) {
            throw new IllegalStateException("The current state '" + this.state.getId() + "' of this flow '" + this.flow.getId() + "' is not a view state - view scope not accessible");
        }
        return (MutableAttributeMap)this.scope.get(VIEW_SCOPE_ATTRIBUTE);
    }

    public FlowSession getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setCurrentState(State state) {
        if (this.state != null && this.state.isViewState()) {
            this.destroyViewScope();
        }
        this.state = state;
        if (this.state.isViewState()) {
            this.initViewScope();
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.flowId = (String)in.readObject();
        this.stateId = (String)in.readObject();
        this.scope = (MutableAttributeMap)in.readObject();
        this.parent = (FlowSessionImpl)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.flow.getId());
        out.writeObject(this.state.getId());
        out.writeObject(this.scope);
        out.writeObject(this.parent);
    }

    Flow getFlow() {
        return this.flow;
    }

    void setFlow(Flow flow) {
        Assert.notNull((Object)flow, (String)"The flow is required");
        this.flow = flow;
    }

    void setState(State state) {
        Assert.notNull((Object)state, (String)"The state is required");
        Assert.isTrue((this.flow == state.getOwner() ? 1 : 0) != 0, (String)"The state does not belong to the flow associated with this flow session");
        this.state = state;
    }

    String getFlowId() {
        return this.flowId;
    }

    String getStateId() {
        return this.stateId;
    }

    private void initViewScope() {
        this.scope.put(VIEW_SCOPE_ATTRIBUTE, new LocalAttributeMap());
    }

    private void destroyViewScope() {
        this.scope.remove(VIEW_SCOPE_ATTRIBUTE);
    }

    public String toString() {
        if (this.flow != null) {
            return new ToStringCreator((Object)this).append("flow", (Object)this.flow.getId()).append("state", this.state != null ? this.state.getId() : null).append("scope", (Object)this.scope).toString();
        }
        return "[Unhydrated session '" + this.flowId + "' in state '" + this.stateId + "']";
    }
}

