/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.registry;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.engine.model.registry.FlowModelRegistry;
import org.springframework.webflow.engine.model.registry.NoSuchFlowModelException;

public class FlowModelRegistryImpl
implements FlowModelRegistry {
    private static final Log logger;
    private Map flowModels = new TreeMap();
    private FlowModelRegistry parent;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.engine.model.registry.FlowModelRegistryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public FlowModel getFlowModel(String id) throws NoSuchFlowModelException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting FlowModel with id '" + id + "'"));
            }
            return this.getFlowModelHolder(id).getFlowModel();
        }
        catch (NoSuchFlowModelException e) {
            if (this.parent != null) {
                return this.parent.getFlowModel(id);
            }
            throw e;
        }
    }

    public void setParent(FlowModelRegistry parent) {
        this.parent = parent;
    }

    public void registerFlowModel(String id, FlowModelHolder modelHolder) {
        Assert.notNull((Object)modelHolder, (String)"The holder of the flow model to register is required");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering flow model " + modelHolder));
        }
        this.flowModels.put(id, modelHolder);
    }

    private FlowModelHolder getFlowModelHolder(String id) throws NoSuchFlowModelException {
        FlowModelHolder holder = (FlowModelHolder)this.flowModels.get(id);
        if (holder == null) {
            throw new NoSuchFlowModelException(id);
        }
        return holder;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowModels", (Object)this.flowModels).append("parent", (Object)this.parent).toString();
    }
}

