/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.FormatterRegistry;
import org.springframework.binding.format.InvalidFormatException;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.binding.mapping.impl.DefaultMappingContext;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContextErrors;
import org.springframework.binding.message.MessageResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.definition.TransitionableStateDefinition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.expression.DefaultExpressionParserFactory;
import org.springframework.webflow.mvc.view.BindingModel;

public abstract class AbstractMvcView
implements View {
    private static final MappingResultsCriteria PROPERTY_NOT_FOUND_ERROR = new PropertyNotFoundError();
    private static final MappingResultsCriteria MAPPING_ERROR = new MappingError();
    private org.springframework.web.servlet.View view;
    private RequestContext requestContext;
    private ExpressionParser expressionParser = DefaultExpressionParserFactory.getExpressionParser();
    private FormatterRegistry formatterRegistry;
    private MappingResults mappingResults;
    private boolean viewErrors;
    private String eventId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public AbstractMvcView(org.springframework.web.servlet.View view, RequestContext requestContext) {
        this.view = view;
        this.requestContext = requestContext;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void setFormatterRegistry(FormatterRegistry formatterRegistry) {
        this.formatterRegistry = formatterRegistry;
    }

    public void render() throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(this.flowScopes());
        this.exposeBindingModel(model);
        model.put("flowRequestContext", this.requestContext);
        FlowExecutionKey key = this.requestContext.getFlowExecutionContext().getKey();
        if (key != null) {
            model.put("flowExecutionKey", this.requestContext.getFlowExecutionContext().getKey().toString());
            model.put("flowExecutionUrl", this.requestContext.getFlowExecutionUrl());
        }
        model.put("currentUser", this.requestContext.getExternalContext().getCurrentUser());
        try {
            this.doRender(model);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception occurred rendering view " + this.view, e);
        }
    }

    public void processUserEvent() {
        this.determineEventId(this.requestContext);
        if (this.eventId == null) {
            return;
        }
        Object model = this.getModelObject();
        if (model == null) {
            return;
        }
        if (this.shouldBind(model)) {
            this.mappingResults = this.bind(model);
            if (this.hasMappingErrors(this.mappingResults)) {
                this.viewErrors = true;
                this.addErrorMessages(this.mappingResults);
            } else {
                this.validate(model);
                if (this.requestContext.getMessageContext().hasErrorMessages()) {
                    this.viewErrors = true;
                }
            }
        }
    }

    public boolean hasFlowEvent() {
        return this.eventId != null && !this.viewErrors;
    }

    public Event getFlowEvent() {
        if (!this.hasFlowEvent()) {
            return null;
        }
        return new Event(this, this.eventId, this.requestContext.getRequestParameters().asAttributeMap());
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected org.springframework.web.servlet.View getView() {
        return this.view;
    }

    protected abstract void doRender(Map var1) throws Exception;

    private Map flowScopes() {
        if (this.requestContext.getCurrentState().isViewState()) {
            return this.requestContext.getConversationScope().union(this.requestContext.getFlowScope()).union(this.requestContext.getViewScope()).union(this.requestContext.getFlashScope()).union(this.requestContext.getRequestScope()).asMap();
        }
        return this.requestContext.getConversationScope().union(this.requestContext.getFlowScope()).union(this.requestContext.getFlashScope()).union(this.requestContext.getRequestScope()).asMap();
    }

    private void exposeBindingModel(Map model) {
        Object modelObject = this.getModelObject();
        if (modelObject != null) {
            BindingModel bindingModel = new BindingModel(this.getModelExpression().getExpressionString(), modelObject, this.expressionParser, this.formatterRegistry, this.requestContext.getMessageContext());
            bindingModel.setMappingResults(this.mappingResults);
            model.put(String.valueOf(BindingResult.MODEL_KEY_PREFIX) + this.getModelExpression().getExpressionString(), bindingModel);
        }
    }

    private Object getModelObject() {
        Expression model = this.getModelExpression();
        if (model != null) {
            return model.getValue((Object)this.requestContext);
        }
        return null;
    }

    private Expression getModelExpression() {
        return (Expression)this.requestContext.getCurrentState().getAttributes().get("model");
    }

    private boolean shouldBind(Object model) {
        TransitionableStateDefinition currentState = (TransitionableStateDefinition)this.requestContext.getCurrentState();
        TransitionDefinition transition = currentState.getTransition(this.eventId);
        if (transition != null && transition.getAttributes().contains("bind")) {
            return transition.getAttributes().getBoolean("bind");
        }
        return true;
    }

    private MappingResults bind(Object model) {
        DefaultMapper mapper = new DefaultMapper();
        this.addDefaultMappings(mapper, this.requestContext.getRequestParameters(), model);
        return mapper.map((Object)this.requestContext.getRequestParameters(), model);
    }

    private void addDefaultMappings(DefaultMapper mapper, ParameterMap requestParameters, Object model) {
        Iterator it = requestParameters.asMap().keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            RequestParameterExpression source = new RequestParameterExpression(name);
            Expression target = this.expressionParser.parseExpression(name, (ParserContext)new FluentParserContext().evaluate(model.getClass()));
            DefaultMapping mapping = new DefaultMapping((Expression)source, target);
            mapping.setTypeConverter((ConversionExecutor)new FormatterBackedMappingConversionExecutor(this.formatterRegistry));
            mapper.addMapping(mapping);
        }
    }

    private boolean hasMappingErrors(MappingResults results) {
        return results.hasErrorResults() && !this.onlyPropertyNotFoundErrorsPresent(results);
    }

    private boolean onlyPropertyNotFoundErrorsPresent(MappingResults results) {
        return results.getResults(PROPERTY_NOT_FOUND_ERROR).size() == this.mappingResults.getErrorResults().size();
    }

    private void addErrorMessages(MappingResults results) {
        List errors = results.getResults(MAPPING_ERROR);
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            MappingResult error = (MappingResult)it.next();
            this.requestContext.getMessageContext().addMessage(this.createMessageResolver(error));
        }
    }

    private MessageResolver createMessageResolver(MappingResult error) {
        String field = error.getMapping().getTargetExpression().getExpressionString();
        String errorCode = error.getResult().getErrorCode();
        String propertyErrorCode = this.getModelExpression().getExpressionString() + '.' + field + '.' + errorCode;
        return new MessageBuilder().error().source((Object)field).code(propertyErrorCode).code(errorCode).resolvableArg((Object)field).defaultText(String.valueOf(errorCode) + " on " + field).build();
    }

    private void validate(Object model) {
        String validatorName;
        ApplicationContext beanFactory;
        String validateMethodName = "validate" + StringUtils.capitalize((String)this.requestContext.getCurrentState().getId());
        Class<?> clazz = model.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.binding.message.MessageContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method validateMethod = ReflectionUtils.findMethod(clazz, (String)validateMethodName, (Class[])classArray);
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)model, (Object[])new Object[]{this.requestContext.getMessageContext()});
        }
        if ((beanFactory = this.requestContext.getActiveFlow().getApplicationContext()) != null && beanFactory.containsBean(validatorName = String.valueOf(this.getModelExpression().getExpressionString()) + "Validator")) {
            Object validator = beanFactory.getBean(validatorName);
            Class<?> clazz3 = validator.getClass();
            Class[] classArray2 = new Class[2];
            classArray2[0] = model.getClass();
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("org.springframework.binding.message.MessageContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[1] = clazz4;
            validateMethod = ReflectionUtils.findMethod(clazz3, (String)validateMethodName, (Class[])classArray2);
            if (validateMethod != null) {
                ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, this.requestContext.getMessageContext()});
            } else {
                Class<?> clazz5 = validator.getClass();
                Class[] classArray3 = new Class[2];
                classArray3[0] = model.getClass();
                Class<?> clazz6 = class$2;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$2 = Class.forName("org.springframework.validation.Errors");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray3[1] = clazz6;
                validateMethod = ReflectionUtils.findMethod(clazz5, (String)validateMethodName, (Class[])classArray3);
                if (validateMethod != null) {
                    ReflectionUtils.invokeMethod((Method)validateMethod, (Object)validator, (Object[])new Object[]{model, new MessageContextErrors(this.requestContext.getMessageContext())});
                }
            }
        }
    }

    private void determineEventId(RequestContext context) {
        this.eventId = WebUtils.findParameterValue((Map)context.getRequestParameters().asMap(), (String)"_eventId");
    }

    private static class FormatterBackedMappingConversionExecutor
    implements ConversionExecutor {
        private FormatterRegistry formatterRegistry;

        public FormatterBackedMappingConversionExecutor(FormatterRegistry formatterRegistry) {
            this.formatterRegistry = formatterRegistry;
        }

        public Object execute(Object source) throws ConversionException {
            throw new UnsupportedOperationException("Should never be called");
        }

        public Object execute(Object source, Object context) throws ConversionException {
            String formattedValue = (String)source;
            DefaultMappingContext mappingContext = (DefaultMappingContext)context;
            Expression target = mappingContext.getCurrentMapping().getTargetExpression();
            Class targetClass = this.getTargetClass();
            if (targetClass == null) {
                try {
                    targetClass = target.getValueType(mappingContext.getTarget());
                }
                catch (EvaluationException evaluationException) {}
            }
            if (targetClass == null) {
                return formattedValue;
            }
            Formatter formatter = this.getFormatter(target, targetClass);
            if (formatter != null) {
                try {
                    return formatter.parse(formattedValue);
                }
                catch (InvalidFormatException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    throw new ConversionException((Object)clazz, targetClass, (Throwable)e);
                }
            }
            return formattedValue;
        }

        private Formatter getFormatter(Expression target, Class targetClass) {
            if (this.formatterRegistry != null) {
                Formatter formatter = this.formatterRegistry.getFormatter(target.getExpressionString());
                if (formatter != null) {
                    return formatter;
                }
                return this.formatterRegistry.getFormatter(targetClass);
            }
            return null;
        }

        public Class getSourceClass() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public Class getTargetClass() {
            return null;
        }
    }

    private static class MappingError
    implements MappingResultsCriteria {
        private MappingError() {
        }

        public boolean test(MappingResult result) {
            return result.getResult().isError() && !PROPERTY_NOT_FOUND_ERROR.test(result);
        }
    }

    private static class PropertyNotFoundError
    implements MappingResultsCriteria {
        private PropertyNotFoundError() {
        }

        public boolean test(MappingResult result) {
            return result.getResult().isError() && "propertyNotFound".equals(result.getResult().getErrorCode());
        }
    }

    private static class RequestParameterExpression
    implements Expression {
        private String parameterName;

        public RequestParameterExpression(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getExpressionString() {
            return this.parameterName;
        }

        public Object getValue(Object context) throws EvaluationException {
            ParameterMap map = (ParameterMap)context;
            return map.get(this.parameterName);
        }

        public Class getValueType(Object context) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public void setValue(Object context, Object value) throws EvaluationException {
            throw new UnsupportedOperationException("Setting request parameters is not allowed");
        }
    }
}

