/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListenerAdapter;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;

public class JpaFlowExecutionListener
extends FlowExecutionListenerAdapter {
    public static final String PERSISTENCE_CONTEXT_ATTRIBUTE = "persistenceContext";
    private EntityManagerFactory entityManagerFactory;
    private TransactionTemplate transactionTemplate;

    public JpaFlowExecutionListener(EntityManagerFactory entityManagerFactory, PlatformTransactionManager transactionManager) {
        this.entityManagerFactory = entityManagerFactory;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public void sessionStarting(RequestContext context, FlowSession session, MutableAttributeMap input) {
        FlowSession parent;
        if (!session.isRoot() && this.isPersistenceContext((parent = session.getParent()).getDefinition())) {
            this.unbind(this.getEntityManager(parent));
        }
        if (this.isPersistenceContext(session.getDefinition())) {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            session.getScope().put(PERSISTENCE_CONTEXT_ATTRIBUTE, em);
            this.bind(em);
        }
    }

    public void paused(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            this.unbind(this.getEntityManager(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    public void resuming(RequestContext context) {
        if (this.isPersistenceContext(context.getActiveFlow())) {
            this.bind(this.getEntityManager(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    public void sessionEnded(RequestContext context, FlowSession session, String outcome, AttributeMap output) {
        FlowSession parent;
        if (this.isPersistenceContext(session.getDefinition())) {
            final EntityManager em = (EntityManager)session.getScope().remove(PERSISTENCE_CONTEXT_ATTRIBUTE);
            Boolean commitStatus = session.getState().getAttributes().getBoolean("commit");
            if (Boolean.TRUE.equals(commitStatus)) {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        em.joinTransaction();
                    }
                });
            }
            this.unbind(em);
            em.close();
        }
        if (!session.isRoot() && this.isPersistenceContext((parent = session.getParent()).getDefinition())) {
            this.bind(this.getEntityManager(parent));
        }
    }

    public void exceptionThrown(RequestContext context, FlowExecutionException exception) {
        if (context.getFlowExecutionContext().isActive() && this.isPersistenceContext(context.getActiveFlow())) {
            this.unbind(this.getEntityManager(context.getFlowExecutionContext().getActiveSession()));
        }
    }

    private boolean isPersistenceContext(FlowDefinition flow) {
        return flow.getAttributes().contains(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private EntityManager getEntityManager(FlowSession session) {
        return (EntityManager)session.getScope().get(PERSISTENCE_CONTEXT_ATTRIBUTE);
    }

    private void bind(EntityManager em) {
        TransactionSynchronizationManager.bindResource((Object)this.entityManagerFactory, (Object)new EntityManagerHolder(em));
    }

    private void unbind(EntityManager em) {
        if (TransactionSynchronizationManager.hasResource((Object)this.entityManagerFactory)) {
            TransactionSynchronizationManager.unbindResource((Object)this.entityManagerFactory);
        }
    }
}

