/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.binding.message.DefaultMessageContextFactory;
import org.springframework.binding.message.MessageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockExternalContext;
import org.springframework.webflow.test.MockFlowExecutionContext;

public class MockRequestContext
implements RequestContext {
    private FlowExecutionContext flowExecutionContext;
    private ExternalContext externalContext;
    private MessageContext messageContext;
    private MutableAttributeMap requestScope = new LocalAttributeMap();
    private MutableAttributeMap attributes = new LocalAttributeMap();
    private Event currentEvent;
    private Transition currentTransition;

    public MockRequestContext() {
        this(new MockFlowExecutionContext());
    }

    public MockRequestContext(Flow flow) {
        this(new MockFlowExecutionContext(flow));
    }

    public MockRequestContext(ParameterMap requestParameterMap) {
        this.flowExecutionContext = new MockFlowExecutionContext();
        this.externalContext = new MockExternalContext(requestParameterMap);
        this.messageContext = new DefaultMessageContextFactory((MessageSource)new StaticMessageSource()).createMessageContext();
    }

    public MockRequestContext(FlowExecutionContext flowExecutionContext) {
        this.flowExecutionContext = flowExecutionContext;
        this.externalContext = new MockExternalContext();
        this.messageContext = new DefaultMessageContextFactory((MessageSource)new StaticMessageSource()).createMessageContext();
    }

    public FlowDefinition getActiveFlow() {
        return this.getFlowExecutionContext().getActiveSession().getDefinition();
    }

    public StateDefinition getCurrentState() {
        return this.getFlowExecutionContext().getActiveSession().getState();
    }

    public boolean inViewState() {
        return this.getFlowExecutionContext().isActive() && this.getCurrentState() != null && this.getCurrentState().isViewState();
    }

    public MutableAttributeMap getRequestScope() {
        return this.requestScope;
    }

    public MutableAttributeMap getFlashScope() {
        return this.getMockFlowExecutionContext().getFlashScope();
    }

    public MutableAttributeMap getViewScope() throws IllegalStateException {
        return this.getMockFlowExecutionContext().getActiveSession().getViewScope();
    }

    public MutableAttributeMap getFlowScope() {
        return this.getFlowExecutionContext().getActiveSession().getScope();
    }

    public MutableAttributeMap getConversationScope() {
        return this.getMockFlowExecutionContext().getConversationScope();
    }

    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecutionContext;
    }

    public Event getCurrentEvent() {
        return this.currentEvent;
    }

    public TransitionDefinition getCurrentTransition() {
        return this.currentTransition;
    }

    public MutableAttributeMap getAttributes() {
        return this.attributes;
    }

    public String getFlowExecutionUrl() {
        if (this.flowExecutionContext.getKey() == null) {
            throw new IllegalStateException("Flow execution key not yet assigned; unable to build the flow execution url");
        }
        String flowDefinitionId = this.flowExecutionContext.getDefinition().getId();
        return this.externalContext.getFlowExecutionUrl(flowDefinitionId, this.flowExecutionContext.getKey().toString());
    }

    public void sendFlowExecutionRedirect() {
        if (this.flowExecutionContext.getKey() == null) {
            throw new IllegalStateException("Flow execution key not yet assigned; unable to send a flow execution redirect request");
        }
        this.externalContext.requestFlowExecutionRedirect();
    }

    public void setActiveSession(FlowSession flowSession) {
        this.getMockFlowExecutionContext().setActiveSession(flowSession);
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    public void setFlowExecutionContext(FlowExecutionContext flowExecutionContext) {
        this.flowExecutionContext = flowExecutionContext;
    }

    public void setCurrentEvent(Event event) {
        this.currentEvent = event;
    }

    public void setCurrentTransition(Transition transition) {
        this.currentTransition = transition;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public void putRequestParameter(String parameterName, String parameterValue) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValue);
    }

    public void putRequestParameter(String parameterName, String[] parameterValues) {
        this.getMockExternalContext().putRequestParameter(parameterName, parameterValues);
    }

    public Flow getRootFlow() {
        return this.getMockFlowExecutionContext().getDefinitionInternal();
    }

    public MutableAttributeMap getAttributeMap() {
        return this.attributes;
    }

    public MockFlowExecutionContext getMockFlowExecutionContext() {
        return (MockFlowExecutionContext)this.flowExecutionContext;
    }

    public MockExternalContext getMockExternalContext() {
        return (MockExternalContext)this.externalContext;
    }
}

