/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.string;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovObjectUtil {
    private static Log log = LogFactory.getLog(EgovObjectUtil.class);

    private EgovObjectUtil() {
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException, Exception {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static Object instantiate(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        try {
            Class<?> clazz = EgovObjectUtil.loadClass(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is can not instantialized."));
            }
            throw new ClassNotFoundException();
        }
        catch (InstantiationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is can not instantialized."));
            }
            throw new InstantiationException();
        }
        catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is not accessed."));
            }
            throw new IllegalAccessException();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is not accessed."));
            }
            throw new Exception(e);
        }
    }

    public static Object instantiate(String className, String[] types, Object[] values) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        Class[] classParams = new Class[values.length];
        Object[] objectParams = new Object[values.length];
        try {
            Class<?> clazz = EgovObjectUtil.loadClass(className);
            for (int i = 0; i < values.length; ++i) {
                classParams[i] = EgovObjectUtil.loadClass(types[i]);
                objectParams[i] = values[i];
            }
            Constructor<?> constructor = clazz.getConstructor(classParams);
            return constructor.newInstance(values);
        }
        catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is can not instantialized."));
            }
            throw new ClassNotFoundException();
        }
        catch (InstantiationException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is can not instantialized."));
            }
            throw new InstantiationException();
        }
        catch (IllegalAccessException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is not accessed."));
            }
            throw new IllegalAccessException();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)(className + " : Class is not accessed."));
            }
            throw new Exception(e);
        }
    }

    public static boolean isNull(Object object) {
        return object == null || object.equals(null);
    }
}

