/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.ServiceContractResolver;
import org.apache.cxf.endpoint.ServiceContractResolverRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class ServiceContractResolverRegistryImpl
implements ServiceContractResolverRegistry {
    private Bus bus;
    private List<ServiceContractResolver> resolvers = new CopyOnWriteArrayList<ServiceContractResolver>();

    public ServiceContractResolverRegistryImpl() {
    }

    public ServiceContractResolverRegistryImpl(Bus b) {
        this.setBus(b);
    }

    public final void setBus(Bus b) {
        this.bus = b;
        if (this.bus != null) {
            this.bus.setExtension((Object)this, ServiceContractResolverRegistry.class);
        }
    }

    public URI getContractLocation(QName qname) {
        for (ServiceContractResolver resolver : this.resolvers) {
            URI contractLocation = resolver.getContractLocation(qname);
            if (null == contractLocation) continue;
            return contractLocation;
        }
        return null;
    }

    public boolean isRegistered(ServiceContractResolver resolver) {
        return this.resolvers.contains(resolver);
    }

    public synchronized void register(ServiceContractResolver resolver) {
        this.resolvers.add(resolver);
    }

    public synchronized void unregister(ServiceContractResolver resolver) {
        this.resolvers.remove(resolver);
    }

    protected List<ServiceContractResolver> getResolvers() {
        return this.resolvers;
    }
}

