/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata;

import egovframework.rte.itl.integration.metadata.SystemDefinition;
import egovframework.rte.itl.integration.util.Validatable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.StringUtils;

public class ServiceDefinition
implements Validatable {
    private String key;
    private SystemDefinition system;
    private String id;
    private String name;
    private String requestMessageTypeId;
    private String responseMessageTypeId;
    private String serviceProviderBeanId;
    private boolean standard;
    private boolean using;
    private boolean valid = false;
    private AtomicBoolean statusChanged = new AtomicBoolean(false);

    public ServiceDefinition() {
    }

    public ServiceDefinition(String key, SystemDefinition system, String id, String name, String requestMessageTypeId, String responseMessageTypeId, String serviceProviderBeanId, boolean standard, boolean using) {
        this.key = key;
        this.system = system;
        this.id = id;
        this.name = name;
        this.requestMessageTypeId = requestMessageTypeId;
        this.responseMessageTypeId = responseMessageTypeId;
        this.serviceProviderBeanId = serviceProviderBeanId;
        this.standard = standard;
        this.using = using;
        this.statusChanged.set(true);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.statusChanged.set(true);
    }

    public SystemDefinition getSystem() {
        return this.system;
    }

    public void setSystem(SystemDefinition system) {
        this.system = system;
        this.statusChanged.set(true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.statusChanged.set(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.statusChanged.set(true);
    }

    public String getRequestMessageTypeId() {
        return this.requestMessageTypeId;
    }

    public void setRequestMessageTypeId(String requestMessageTypeId) {
        this.requestMessageTypeId = requestMessageTypeId;
        this.statusChanged.set(true);
    }

    public String getResponseMessageTypeId() {
        return this.responseMessageTypeId;
    }

    public void setResponseMessageTypeId(String responseMessageTypeId) {
        this.responseMessageTypeId = responseMessageTypeId;
        this.statusChanged.set(true);
    }

    public String getServiceProviderBeanId() {
        return this.serviceProviderBeanId;
    }

    public void setServiceProviderBeanId(String serviceProviderBeanId) {
        this.serviceProviderBeanId = serviceProviderBeanId;
        this.statusChanged.set(true);
    }

    public boolean isStandard() {
        return this.standard;
    }

    public void setStandard(boolean standard) {
        this.standard = standard;
    }

    public boolean isUsing() {
        return this.using;
    }

    public void setUsing(boolean using) {
        this.using = using;
    }

    public boolean isValid() {
        if (this.statusChanged.getAndSet(false)) {
            boolean bl = this.valid = StringUtils.hasText((String)this.key) && this.system != null && StringUtils.hasText((String)this.id) && StringUtils.hasText((String)this.name) && StringUtils.hasText((String)this.requestMessageTypeId) && StringUtils.hasText((String)this.responseMessageTypeId);
            if (this.system != null) {
                this.valid = this.valid && this.system.isValid();
            }
        }
        return this.valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("\n\tkey = ").append(StringUtils.quote((String)this.key));
        if (this.system == null) {
            sb.append("\n\tsystem = null");
        } else {
            sb.append("\n\tsystem.key = ").append(StringUtils.quote((String)this.system.getKey()));
        }
        sb.append("\n\tid = ").append(StringUtils.quote((String)this.id)).append("\n\tname = ").append(StringUtils.quote((String)this.name)).append("\n\trequestMessageTypeId = ").append(StringUtils.quote((String)this.requestMessageTypeId)).append("\n\tresponseMessageTypeId = ").append(StringUtils.quote((String)this.responseMessageTypeId)).append("\n\tserivceProviderBeanId = ").append(StringUtils.quote((String)this.serviceProviderBeanId)).append("\n\tusing = ").append(this.using).append("\n\tstandard = ").append(this.standard).append("\n}");
        return sb.toString();
    }
}

