/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice;

import egovframework.rte.itl.integration.EgovIntegrationContext;
import egovframework.rte.itl.integration.EgovIntegrationNoSuchServiceException;
import egovframework.rte.itl.integration.EgovIntegrationService;
import egovframework.rte.itl.integration.EgovIntegrationServiceProvider;
import egovframework.rte.itl.integration.metadata.IntegrationDefinition;
import egovframework.rte.itl.integration.metadata.dao.IntegrationDefinitionDao;
import egovframework.rte.itl.integration.monitor.EgovIntegrationServiceMonitor;
import egovframework.rte.itl.integration.type.CircularInheritanceException;
import egovframework.rte.itl.integration.type.NoSuchTypeException;
import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.TypeLoader;
import egovframework.rte.itl.webservice.EgovWebService;
import egovframework.rte.itl.webservice.data.WebServiceClientDefinition;
import egovframework.rte.itl.webservice.data.WebServiceServerDefinition;
import egovframework.rte.itl.webservice.data.dao.WebServiceClientDefinitionDao;
import egovframework.rte.itl.webservice.data.dao.WebServiceServerDefinitionDao;
import egovframework.rte.itl.webservice.service.EgovWebServiceClassLoader;
import egovframework.rte.itl.webservice.service.MessageConverter;
import egovframework.rte.itl.webservice.service.impl.EgovWebServiceClientImpl;
import egovframework.rte.itl.webservice.service.impl.MessageConverterImpl;
import egovframework.rte.itl.webservice.service.impl.ServiceBridgeImpl;
import egovframework.rte.itl.webservice.service.impl.ServiceEndpointInfoImpl;
import egovframework.rte.itl.webservice.service.impl.ServiceEndpointInterfaceInfoImpl;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class EgovWebServiceContext
implements EgovIntegrationContext,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovWebServiceContext.class);
    protected String organizationId;
    protected String systemId;
    protected long defaultTimeout;
    protected IntegrationDefinitionDao integrationDefinitionDao;
    protected WebServiceClientDefinitionDao webServiceClientDefinitionDao;
    protected WebServiceServerDefinitionDao webServiceServerDefinitionDao;
    protected TypeLoader typeLoader;
    protected EgovWebServiceClassLoader classLoader;
    protected ApplicationContext applicationContext;
    protected MessageConverter messageConverter;
    protected Map<String, EgovWebService> serviceMap;
    protected List<ServerInfo> serverList;
    protected Bus bus;

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setIntegrationDefinitionDao(IntegrationDefinitionDao integrationDefinitionDao) {
        this.integrationDefinitionDao = integrationDefinitionDao;
    }

    public void setWebServiceClientDefinitionDao(WebServiceClientDefinitionDao webServiceClientDefinitionDao) {
        this.webServiceClientDefinitionDao = webServiceClientDefinitionDao;
    }

    public void setWebServiceServerDefinitionDao(WebServiceServerDefinitionDao webServiceServerDefinitionDao) {
        this.webServiceServerDefinitionDao = webServiceServerDefinitionDao;
    }

    public void setTypeLoader(TypeLoader typeLoader) {
        this.typeLoader = typeLoader;
    }

    public void setClassLoader(EgovWebServiceClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void init() throws IllegalArgumentException {
        LOGGER.debug("Initilaize EgovWebServiceContext");
        if (!StringUtils.hasText((String)this.organizationId)) {
            LOGGER.error("Argument 'organizationId' is null or has no text (organizationId = " + (this.organizationId == null ? "\"" : "") + this.organizationId + (this.organizationId == null ? "\"" : "") + ")");
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)this.systemId)) {
            LOGGER.error("Argument 'systemId' is null or has no text (systemId = " + (this.systemId == null ? "\"" : "") + this.systemId + (this.systemId == null ? "\"" : "") + ")");
            throw new IllegalArgumentException();
        }
        if (this.integrationDefinitionDao == null) {
            LOGGER.error("Argument 'integrationDefinitionDao' is null");
            throw new IllegalArgumentException();
        }
        if (this.webServiceClientDefinitionDao == null) {
            LOGGER.error("Argument 'webServiceClientDefinitionDao' is null");
            throw new IllegalArgumentException();
        }
        if (this.webServiceServerDefinitionDao == null) {
            LOGGER.error("Argument 'webServiceServerDefinitionDao' is null");
            throw new IllegalArgumentException();
        }
        if (this.typeLoader == null) {
            LOGGER.error("Argument 'typeLoader' is null");
            throw new IllegalArgumentException();
        }
        if (this.classLoader == null) {
            LOGGER.error("Argument 'classLoader' is null");
            throw new IllegalArgumentException();
        }
        LOGGER.debug("Create MessageConverter");
        this.messageConverter = new MessageConverterImpl(this.classLoader);
        this.initServerInfo();
        this.initClient();
    }

    protected void initServerInfo() {
        LOGGER.debug("Initialzise Server Info");
        ArrayList<WebServiceServerDefinition> webServiceServerDefinitions = new ArrayList<WebServiceServerDefinition>();
        List integrationDefinitions = this.integrationDefinitionDao.getIntegrationDefinitionOfProvider(this.organizationId, this.systemId);
        LOGGER.debug("Scan IntegrationDefinitions");
        for (IntegrationDefinition integrationDefinition : integrationDefinitions) {
            LOGGER.debug("Create Service Info of IntegrationDefinition({})", (Object)integrationDefinition);
            if (integrationDefinition == null) {
                LOGGER.error("IntegrationDefinition is null");
                continue;
            }
            if (!integrationDefinition.isValid()) {
                LOGGER.error("IntegrationDefinition is invalid");
                continue;
            }
            if (!integrationDefinition.isUsing()) {
                LOGGER.info("IntegrationDefinition({}) is not usable", (Object)integrationDefinition);
                continue;
            }
            if (!integrationDefinition.getProvider().isUsing()) {
                LOGGER.info("IntegrationDefinition({})'s provider service is not usable", (Object)integrationDefinition);
                continue;
            }
            WebServiceServerDefinition webServiceServerDefinition = this.webServiceServerDefinitionDao.getWebServiceServerDefinition(integrationDefinition.getProvider());
            if (webServiceServerDefinition == null) {
                LOGGER.error("WebServiceServerDefinition of IntegrationDefinition({}) does not exist.", (Object)integrationDefinition);
                continue;
            }
            if (!webServiceServerDefinition.isValid()) {
                LOGGER.error("WebServiceServerDefinition of IntegrationDefinition({}) is invalid", (Object)integrationDefinition);
                continue;
            }
            if (webServiceServerDefinitions.contains(webServiceServerDefinition)) continue;
            webServiceServerDefinitions.add(webServiceServerDefinition);
        }
        this.createWebServiceServerModule(webServiceServerDefinitions);
    }

    private void createWebServiceServerModule(List<WebServiceServerDefinition> webServiceServerDefinitions) {
        LOGGER.debug("Create WebService Server Module");
        this.serverList = new ArrayList<ServerInfo>();
        for (WebServiceServerDefinition webServiceServerDefinition : webServiceServerDefinitions) {
            LOGGER.debug("webServiceServerDefinition = {}", (Object)webServiceServerDefinition);
            RecordType requestType = null;
            try {
                requestType = (RecordType)this.typeLoader.getType(webServiceServerDefinition.getServiceDefinition().getRequestMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                LOGGER.error("RequestMessageType RecordType(id = \"{}\")'s definition does not exist. {}", (Object)webServiceServerDefinition.getServiceDefinition().getRequestMessageTypeId(), (Object)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                LOGGER.error("RequestMessageType RecordType(id = \"{}\") has circular inheritance. {}", (Object)webServiceServerDefinition.getServiceDefinition().getRequestMessageTypeId(), (Object)e);
                continue;
            }
            LOGGER.debug("RequestMesageType = {}", (Object)requestType);
            RecordType responseType = null;
            try {
                responseType = (RecordType)this.typeLoader.getType(webServiceServerDefinition.getServiceDefinition().getResponseMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                LOGGER.error("ResponseMessageType RecordType(id = \"{}\")'s definition does not exist. {}", (Object)webServiceServerDefinition.getServiceDefinition().getResponseMessageTypeId(), (Object)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                LOGGER.error("ResponseMessageType RecordType(id = \"{}\") has circular inheritance. {}", (Object)webServiceServerDefinition.getServiceDefinition().getResponseMessageTypeId(), (Object)e);
                continue;
            }
            LOGGER.debug("ResponseMessageType = {}", (Object)responseType);
            ServiceEndpointInfoImpl serviceEndpointInfo = null;
            try {
                serviceEndpointInfo = new ServiceEndpointInfoImpl(webServiceServerDefinition, requestType, responseType);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Cannot create ServiceEndpointInfoImpl {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("ServiceEndpointInfo = {}", (Object)serviceEndpointInfo);
            Class<?> serviceImplClass = null;
            try {
                serviceImplClass = this.classLoader.loadClass(serviceEndpointInfo);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Cannot load ServerEndpoint Class {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("ServiceEndpoint Class = {}", serviceImplClass);
            Object serviceImpl = null;
            try {
                serviceImpl = serviceImplClass.newInstance();
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Cannot instantiate ServiceEndpoint {}", (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                LOGGER.error("Cannot instantiate ServiceEndpoint {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("ServiceEndpoint instance = {}", serviceImpl);
            EgovIntegrationServiceProvider provider = null;
            try {
                provider = (EgovIntegrationServiceProvider)this.applicationContext.getBean(webServiceServerDefinition.getServiceDefinition().getServiceProviderBeanId());
            }
            catch (BeansException e) {
                LOGGER.error("Cannot get providerBean(id = \"{}\") {}", (Object)webServiceServerDefinition.getServiceDefinition().getServiceProviderBeanId(), (Object)e);
                continue;
            }
            LOGGER.debug("EgovIntegrationServiceProvider = {}", (Object)provider);
            ServiceBridgeImpl serviceBridge = null;
            try {
                serviceBridge = new ServiceBridgeImpl(provider, serviceEndpointInfo, this.messageConverter);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Cannot create ServiceBridge {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("ServiceBridge = {}", (Object)serviceBridge);
            Field fieldServiceBridge = null;
            String fieldName = this.classLoader.getFieldNameOfServiceBridge();
            try {
                fieldServiceBridge = serviceImplClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                LOGGER.error("ServiceEndpoint does not have the field(name = \"{}\") {}", (Object)fieldName, (Object)e);
                continue;
            }
            try {
                fieldServiceBridge.set(serviceImpl, serviceBridge);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Cannot set ServiceBridge to provider {}", (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Cannot set ServiceBridge to provider {}", (Throwable)e);
                continue;
            }
            catch (SecurityException e) {
                LOGGER.error("Cannot set ServiceBridge to provider {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("Add new ServiceInfo");
            this.serverList.add(new ServerInfo(webServiceServerDefinition.getAddress(), serviceImpl));
        }
        LOGGER.debug("Finished Initializing Server Info");
    }

    protected void initClient() {
        LOGGER.debug("Initialize Client Info");
        this.serviceMap = new HashMap<String, EgovWebService>();
        List integrationDefinitions = this.integrationDefinitionDao.getIntegrationDefinitionOfConsumer(this.organizationId, this.systemId);
        for (IntegrationDefinition integrationDefinition : integrationDefinitions) {
            LOGGER.debug("Create Client Info of IntegrationDefinition({})", (Object)integrationDefinition);
            if (integrationDefinition == null) {
                LOGGER.error("IntegrationDefinition is null");
                continue;
            }
            if (!integrationDefinition.isValid()) {
                LOGGER.error("IntegrationDefinition is invalid");
                continue;
            }
            if (!integrationDefinition.isUsing()) {
                LOGGER.info("IntegrationDefinition({}) is not usagble", (Object)integrationDefinition);
                continue;
            }
            if (!integrationDefinition.getProvider().isUsing()) {
                LOGGER.info("IntegrationDefinition({})'s provider service is not usable", (Object)integrationDefinition);
                continue;
            }
            WebServiceClientDefinition webServiceClientDefinition = this.webServiceClientDefinitionDao.getWebServiceClientDefinition(integrationDefinition.getProvider());
            if (webServiceClientDefinition == null) {
                LOGGER.error("WebServiceClientDefinition of IntegrationDefinition({}) does not exist.", (Object)integrationDefinition);
                continue;
            }
            if (!webServiceClientDefinition.isValid()) {
                LOGGER.error("WebServiceClientDefinition of IntegrationDefinition({}) is invalid", (Object)integrationDefinition);
                continue;
            }
            LOGGER.debug("WebServiceClientDefinition = " + webServiceClientDefinition);
            RecordType requestType = null;
            try {
                requestType = (RecordType)this.typeLoader.getType(webServiceClientDefinition.getServiceDefinition().getRequestMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                LOGGER.error("RequestMessageType RecordType(id = \"{}\")'s definition does not exist. {}", (Object)webServiceClientDefinition.getServiceDefinition().getRequestMessageTypeId(), (Object)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                LOGGER.error("RequestMessageType RecordType(id = \"{}\") has circular inheritance. {}", (Object)webServiceClientDefinition.getServiceDefinition().getRequestMessageTypeId(), (Object)e);
                continue;
            }
            LOGGER.debug("RequestMesageType = {}", (Object)requestType);
            RecordType responseType = null;
            try {
                responseType = (RecordType)this.typeLoader.getType(webServiceClientDefinition.getServiceDefinition().getResponseMessageTypeId());
            }
            catch (NoSuchTypeException e) {
                LOGGER.error("ResponseMessageType RecordType(id = \"{}\")'s definition does not exist. {}", (Object)webServiceClientDefinition.getServiceDefinition().getResponseMessageTypeId(), (Object)e);
                continue;
            }
            catch (CircularInheritanceException e) {
                LOGGER.error("ResponseMessageType RecordType(id = \"{}\") has circular inheritance. {}", (Object)webServiceClientDefinition.getServiceDefinition().getResponseMessageTypeId(), (Object)e);
                continue;
            }
            LOGGER.debug("ResponseMessageType = {}", (Object)responseType);
            ServiceEndpointInterfaceInfoImpl serviceEndpointInterfaceInfo = null;
            try {
                serviceEndpointInterfaceInfo = new ServiceEndpointInterfaceInfoImpl(webServiceClientDefinition, requestType, responseType);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Cannot create ServiceEndpointInterfaceInfo {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("ServiceEndpointInterfaceInfo = {}", (Object)serviceEndpointInterfaceInfo);
            EgovWebServiceClientImpl client = null;
            try {
                client = new EgovWebServiceClientImpl(this.classLoader, serviceEndpointInterfaceInfo, this.messageConverter);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Cannot create EgovWebServiceClient {}", (Throwable)e);
                continue;
            }
            catch (MalformedURLException e) {
                LOGGER.error("Cannot create EgovWebServiceClient {}", (Throwable)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Cannot create EgovWebServiceClient {}", (Throwable)e);
                continue;
            }
            catch (SecurityException e) {
                LOGGER.error("Cannot create EgovWebServiceClient {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("EgovWebServiceClient = {}", (Object)client);
            EgovWebService service = null;
            try {
                service = new EgovWebService(integrationDefinition.getId(), this.defaultTimeout, integrationDefinition, client);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Cannot create EgovWebService {}", (Throwable)e);
                continue;
            }
            LOGGER.debug("EgovWebService = {}", (Object)service);
            LOGGER.debug("Add Client Info");
            this.serviceMap.put(integrationDefinition.getId(), service);
        }
        LOGGER.debug("Finish initializing Client Info");
    }

    public void publishServer(Bus bus) {
        LOGGER.debug("Publish Server");
        this.bus = bus;
        BusFactory.setDefaultBus((Bus)bus);
        for (ServerInfo serverInfo : this.serverList) {
            LOGGER.debug("Publish Server (address = \"{}\")", (Object)serverInfo.address);
            try {
                Endpoint.publish((String)serverInfo.address, (Object)serverInfo.serviceImpl);
            }
            catch (Throwable e) {
                LOGGER.error("Fail in publishing Server (address = \"{}\") {}", (Object)serverInfo.address, (Object)e);
            }
        }
        LOGGER.debug("Finish publish Server");
    }

    public void attachMonitor(EgovIntegrationServiceMonitor monitor) {
    }

    public void detachMonitor(EgovIntegrationServiceMonitor monitor) {
    }

    public EgovIntegrationService getService(String id) {
        if (!this.serviceMap.containsKey(id)) {
            throw new EgovIntegrationNoSuchServiceException();
        }
        return (EgovIntegrationService)this.serviceMap.get(id);
    }

    protected static class ServerInfo {
        private String address;
        private Object serviceImpl;

        public ServerInfo(String address, Object serviceImpl) {
            this.address = address;
            this.serviceImpl = serviceImpl;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Object getServiceImpl() {
            return this.serviceImpl;
        }

        public void setServiceImpl(Object serviceImpl) {
            this.serviceImpl = serviceImpl;
        }
    }
}

