/*
 * Decompiled with CFR 0.152.
 */
package egovframework.brte.core.item.file;

import egovframework.brte.core.item.file.EgovByteReader;
import egovframework.brte.core.item.file.EgovByteReaderFactory;
import egovframework.brte.core.item.file.mapping.EgovByteLineMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.FlatFileParseException;
import org.springframework.batch.item.file.NonTransientFlatFileException;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.item.file.separator.SimpleRecordSeparatorPolicy;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovFlatFileByteReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(EgovFlatFileByteReader.class);
    public static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    public static int LINE_CRLF = 2;
    private static final int UNIX_CRLF = 1;
    private static final int WINDOWS_CRLF = 2;
    private RecordSeparatorPolicy recordSeparatorPolicy = new SimpleRecordSeparatorPolicy();
    private Resource resource;
    private EgovByteReader reader;
    private int lineCount = 0;
    private int offset = 0;
    private int length = 0;
    private String[] comments = new String[]{"#"};
    private boolean noInput = false;
    private String encoding = DEFAULT_CHARSET;
    private EgovByteLineMapper<T> lineMapper;
    private boolean strict = true;
    private EgovByteReaderFactory bufferedReaderFactory = new EgovByteReaderFactory();
    byte[] b = null;

    public EgovFlatFileByteReader() {
        this.setName(ClassUtils.getShortName(FlatFileItemReader.class));
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setLineMapper(EgovByteLineMapper<T> lineMapper) {
        this.lineMapper = lineMapper;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOsType(String osType) {
        LINE_CRLF = !osType.toUpperCase().equals("WINDOWS") ? 1 : 2;
    }

    public void setBufferedReaderFactory(EgovByteReaderFactory bufferedReaderFactory) {
        this.bufferedReaderFactory = bufferedReaderFactory;
    }

    public void setComments(String[] comments) {
        this.comments = new String[comments.length];
        System.arraycopy(comments, 0, this.comments, 0, comments.length);
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setRecordSeparatorPolicy(RecordSeparatorPolicy recordSeparatorPolicy) {
        this.recordSeparatorPolicy = recordSeparatorPolicy;
    }

    protected T doRead() throws Exception {
        if (this.noInput) {
            return null;
        }
        byte[] line = this.readLine();
        if (line == null) {
            return null;
        }
        try {
            return this.lineMapper.mapLine(line, this.lineCount);
        }
        catch (Exception ex) {
            throw new FlatFileParseException("Parsing error at line: " + this.lineCount + " in resource=[" + this.resource.getDescription() + "], input=[" + line.toString() + "]", (Throwable)ex, line.toString(), this.lineCount);
        }
    }

    private byte[] readLine() {
        block4: {
            if (this.b == null) {
                this.b = new byte[this.length + LINE_CRLF];
            }
            int line = 0;
            try {
                line = this.reader.read(this.b, this.offset, this.length + LINE_CRLF);
                if (line >= 0) break block4;
                return null;
            }
            catch (IOException e) {
                this.noInput = true;
                throw new NonTransientFlatFileException("Unable to read from resource: [" + this.resource + "]", (Throwable)e, String.valueOf(line), this.lineCount);
            }
        }
        ++this.lineCount;
        return this.b;
    }

    protected void doClose() throws Exception {
        this.lineCount = 0;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input resource must be set");
        Assert.notNull((Object)this.recordSeparatorPolicy, (String)"RecordSeparatorPolicy must be set");
        this.noInput = true;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + this.resource);
            }
            logger.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must be readable (reader is in 'strict' mode): " + this.resource);
            }
            logger.warn((Object)("Input resource is not readable " + this.resource.getDescription()));
            return;
        }
        this.reader = this.bufferedReaderFactory.create(this.resource, this.encoding);
        this.noInput = false;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.lineMapper, (String)"LineMapper is required");
    }

    protected void jumpToItem(int itemIndex) throws Exception {
        int i = 0;
        while (i < itemIndex) {
            this.readLine();
            ++i;
        }
    }
}

