/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonstopThreadPool {
    private final ThreadFactory threadFactory;
    private final List<WorkerThreadLocal> workers = new ArrayList<WorkerThreadLocal>();
    private final Object workersLock = new Object();
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private final ThreadLocal<WorkerThreadLocal> workerThreadLocal = new ThreadLocal<WorkerThreadLocal>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected WorkerThreadLocal initialValue() {
            WorkerThreadLocal local = new WorkerThreadLocal(NonstopThreadPool.this.threadFactory);
            Object object = NonstopThreadPool.this.workersLock;
            synchronized (object) {
                if (NonstopThreadPool.this.state.get() == State.SHUTDOWN) {
                    NonstopThreadPool.this.rejectExecutionAfterShutdown();
                }
                NonstopThreadPool.this.workers.add(local);
            }
            return local;
        }
    };

    public NonstopThreadPool(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    private void rejectExecutionAfterShutdown() {
        throw new RejectedExecutionException("The thread pool has already shut down.");
    }

    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException("Task cannot be null");
        }
        return this.workerThreadLocal.get().submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        this.state.set(State.SHUTDOWN);
        Object object = this.workersLock;
        synchronized (object) {
            for (WorkerThreadLocal worker : this.workers) {
                worker.shutdownNow();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        SHUTDOWN;

    }

    private static class WorkerTaskHolder {
        private Runnable task;

        private WorkerTaskHolder() {
        }

        public synchronized void addTask(Runnable runnable) {
            this.task = runnable;
        }

        public synchronized Runnable consumeTask() {
            if (this.task == null) {
                return null;
            }
            Runnable rv = this.task;
            this.task = null;
            return rv;
        }

        public synchronized boolean isTaskAvailable() {
            return this.task != null;
        }
    }

    private static class Worker
    implements Runnable {
        private final WorkerTaskHolder workerTaskHolder = new WorkerTaskHolder();
        private volatile boolean shutdown;
        private volatile Thread workerThread;
        private volatile boolean runningTask;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.workerThread = Thread.currentThread();
            while (!this.shutdown) {
                this.waitUntilTaskAvailable();
                if (this.shutdown) break;
                Runnable task = this.workerTaskHolder.consumeTask();
                if (task == null) continue;
                Worker worker = this;
                synchronized (worker) {
                    this.runningTask = true;
                    if (this.shutdown) {
                        break;
                    }
                }
                task.run();
                worker = this;
                synchronized (worker) {
                    this.runningTask = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownNow() {
            this.shutdown = true;
            Worker worker = this;
            synchronized (worker) {
                this.notifyAll();
                if (this.runningTask) {
                    this.workerThread.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTask(Runnable runnable) {
            Worker worker = this;
            synchronized (worker) {
                this.workerTaskHolder.addTask(runnable);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilTaskAvailable() {
            Worker worker = this;
            synchronized (worker) {
                while (!this.workerTaskHolder.isTaskAvailable()) {
                    if (this.shutdown) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkerThreadLocal {
        private final Worker worker = new Worker();

        public WorkerThreadLocal(ThreadFactory threadFactory) {
            threadFactory.newThread(this.worker).start();
        }

        public void shutdownNow() {
            this.worker.shutdownNow();
        }

        public <T> Future<T> submit(Callable<T> task) {
            FutureTask<T> ftask = new FutureTask<T>(task);
            this.worker.addTask(ftask);
            return ftask;
        }
    }
}

