/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.FacetUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeDefinition;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;

public class SimpleTypeRestrictionUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private SimpleTypeDefinition _typeDefinition = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean foundFacets = false;

    public SimpleTypeRestrictionUnmarshaller(SchemaContext schemaContext, SimpleTypeDefinition typeDefinition, AttributeSet atts) throws XMLException {
        super(schemaContext);
        this._typeDefinition = typeDefinition;
        this._schema = typeDefinition.getSchema();
        String base = atts.getValue("base");
        if (base != null && base.length() > 0) {
            XMLType baseType = this._schema.getType(base);
            if (baseType == null) {
                this._typeDefinition.setBaseTypeName(base);
            } else {
                if (baseType.getStructureType() == 6) {
                    String err = "The base type of a simpleType cannot be a complexType.";
                    throw new IllegalStateException(err);
                }
                this._typeDefinition.setBaseType((SimpleType)baseType);
            }
        }
    }

    public String elementName() {
        return "restriction";
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if (name.equals("annotation")) {
            if (this.foundFacets || this.foundSimpleType) {
                this.error("An annotation must appear as the first child of 'restriction' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'restriction' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
        } else if ("simpleType".equals(name)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear as a child of 'restriction' elements.");
            }
            if (this.foundFacets) {
                this.error("A 'simpleType', as a child of 'restriction' elements, must appear before any facets.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if (FacetUnmarshaller.isFacet(name)) {
            this.foundFacets = true;
            this.unmarshaller = new FacetUnmarshaller(this.getSchemaContext(), name, atts);
        } else {
            this.illegalElement(name);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._typeDefinition.setAnnotation(ann);
        } else if ("simpleType".equals(name)) {
            SimpleType type = (SimpleType)this.unmarshaller.getObject();
            this._typeDefinition.setBaseType(type);
        } else {
            Facet facet = (Facet)this.unmarshaller.getObject();
            facet.setOwningType((SimpleType)this._typeDefinition.getBaseType());
            this._typeDefinition.addFacet(facet);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

