/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata.dao.hibernate;

import egovframework.rte.itl.integration.metadata.IntegrationDefinition;
import egovframework.rte.itl.integration.metadata.dao.IntegrationDefinitionDao;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateIntegrationDefinitionDao
extends HibernateDaoSupport
implements IntegrationDefinitionDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateIntegrationDefinitionDao.class);

    @Override
    public IntegrationDefinition getIntegrationDefinition(String id) {
        LOGGER.debug("get IntegrationDefinition (id = \"{}\")", (Object)id);
        IntegrationDefinition integrationDefinition = (IntegrationDefinition)this.getHibernateTemplate().get(IntegrationDefinition.class, (Serializable)((Object)id));
        LOGGER.debug("get IntegrationDefinition (id = \"{}\") = {}", (Object)id, (Object)integrationDefinition);
        return integrationDefinition;
    }

    @Override
    public List<IntegrationDefinition> getIntegrationDefinitionOfConsumer(String consumerOrganizationId, String consumerSystemId) {
        LOGGER.debug("get IntegrationDefinition of Consumer(organizationId = \"{}\", systemId = \"{}\")", (Object)consumerOrganizationId, (Object)consumerSystemId);
        List list = this.getHibernateTemplate().find("from IntegrationDefinition as integrationDefinition where integrationDefinition.consumer.organization.id = ? and integrationDefinition.consumer.id = ?", new Object[]{consumerOrganizationId, consumerSystemId});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("get IntegrationDefinition of Consumer(organizationId = \"{}\", systemId = \"{}\")'s size = {}", new Object[]{consumerOrganizationId, consumerSystemId, list.size()});
            int i = 0;
            for (IntegrationDefinition integrationDefinition : list) {
                LOGGER.debug("[{}] : {}", (Object)i, (Object)integrationDefinition);
                ++i;
            }
        }
        return list;
    }

    @Override
    public List<IntegrationDefinition> getIntegrationDefinitionOfProvider(String providerOrganizationId, String providerSystemId) {
        LOGGER.debug("get IntegrationDefinition of Provider(organizationId = \"{}\", systemId = \"{}\")", (Object)providerOrganizationId, (Object)providerSystemId);
        List list = this.getHibernateTemplate().find("from IntegrationDefinition as integrationDefinition where integrationDefinition.provider.system.organization.id = ? and integrationDefinition.provider.system.id = ?", new Object[]{providerOrganizationId, providerSystemId});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("get IntegrationDefinition of Provider(organizationId = \"{}\", systemId = \"{}\")'s size = {}", new Object[]{providerOrganizationId, providerSystemId, list.size()});
            int i = 0;
            for (IntegrationDefinition integrationDefinition : list) {
                LOGGER.debug("[{}] : {}", (Object)i, (Object)integrationDefinition);
                ++i;
            }
        }
        return list;
    }
}

