/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata.dao.hibernate;

import egovframework.rte.itl.integration.metadata.SystemDefinition;
import egovframework.rte.itl.integration.metadata.dao.SystemDefinitionDao;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateSystemDefinitionDao
extends HibernateDaoSupport
implements SystemDefinitionDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateSystemDefinitionDao.class);

    @Override
    public SystemDefinition getSystemDefinition(String key) {
        LOGGER.debug("get SystemDefinition(key = \"{}\")", (Object)key);
        SystemDefinition systemDefinition = (SystemDefinition)this.getHibernateTemplate().get(SystemDefinition.class, (Serializable)((Object)key));
        LOGGER.debug("get SystemDefinition(key = \"{}\") = {}", (Object)key, (Object)systemDefinition);
        return systemDefinition;
    }

    @Override
    public SystemDefinition getSystemDefinition(String organizationId, String systemId) {
        LOGGER.debug("get SystemDefintion(organizationId = \"{}\", systemId = \"{}\")", (Object)organizationId, (Object)systemId);
        SystemDefinition systemDefinition = null;
        List result = this.getHibernateTemplate().find("from SystemDefinition as system where system.organization.id = ? and system.id = ?", new Object[]{organizationId, systemId});
        if (result != null && result.size() > 0) {
            systemDefinition = (SystemDefinition)result.get(0);
            if (result.size() > 1) {
                LOGGER.debug("get SystemDefintion(organizationId = \"{}\", systemId = \"{}\")'s size is not 1 ({})", new Object[]{organizationId, systemId, result.size()});
            }
        }
        LOGGER.debug("get SystemDefintion(organizationId = \"{}\", systemId = \"{}\") = {}", new Object[]{organizationId, systemId, systemDefinition});
        return systemDefinition;
    }
}

