/*
 * Decompiled with CFR 0.152.
 */
package egovframework.brte.core.item.file.mapping;

import egovframework.brte.core.item.file.mapping.EgovObjectMapper;
import egovframework.brte.core.item.file.transform.EgovLineTokenizer;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovDefaultLineMapper<T>
implements LineMapper<T>,
InitializingBean {
    private EgovLineTokenizer<T> tokenizer;
    private EgovObjectMapper<T> objectMapper;

    public T mapLine(String line, int lineNumber) throws Exception {
        return this.objectMapper.mapObject(this.tokenizer.tokenize(line));
    }

    public void setLineTokenizer(EgovLineTokenizer<T> tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void setObjectMapper(EgovObjectMapper<T> objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.tokenizer, (String)"The LineTokenizer must be set");
        Assert.notNull(this.objectMapper, (String)"The ObjectMapper must be set");
    }
}

