/*
 * Decompiled with CFR 0.152.
 */
package egovframework.brte.core.launch.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovSchedulerRunner {
    protected static final Log logger = LogFactory.getLog(EgovSchedulerRunner.class);
    private String contextPath;
    private String schedulerJobPath;
    private List<String> jobPaths;
    private long delayTime;

    public EgovSchedulerRunner(String contextPath, String schedulerJobPath, List<String> jobPaths, long delayTime) {
        this.contextPath = contextPath;
        this.schedulerJobPath = schedulerJobPath;
        this.jobPaths = jobPaths;
        this.delayTime = delayTime;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setSchedulerJobPath(String schedulerJobPath) {
        this.schedulerJobPath = schedulerJobPath;
    }

    public void setJobPath(List<String> jobPaths) {
        this.jobPaths = jobPaths;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public void start() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(this.contextPath);
        paths.add(this.schedulerJobPath);
        for (int index = 0; index < this.jobPaths.size(); ++index) {
            paths.add(this.jobPaths.get(index));
        }
        String[] locations = paths.toArray(new String[paths.size()]);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(locations, false);
        context.refresh();
        logger.warn((Object)("ApplicationContext Running Time: " + this.delayTime / 1000L + " seconds"));
        logger.warn((Object)"CronTrigger is loaded on Spring ApplicationContext");
        try {
            Thread.sleep(this.delayTime);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        context.close();
    }
}

