/*
 * Decompiled with CFR 0.152.
 */
package egovframework.brte.core.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovReflectionSupport<T> {
    private Object object = null;
    private Method[] methods;
    private HashMap<String, Method> methodMap;
    private Type[] fieldType;

    public HashMap<String, Method> getMethodMap() {
        return this.methodMap;
    }

    private Method retrieveMethod(Method[] methods, String methodName) {
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        return method;
    }

    private void createObject(Class<?> type) {
        try {
            this.object = type.newInstance();
        }
        catch (InstantiationException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
    }

    public void generateSetterMethodMap(Class<?> type, String[] names) throws Exception {
        this.methods = type.newInstance().getClass().getMethods();
        this.methodMap = new HashMap();
        for (int i = 0; i < names.length; ++i) {
            try {
                String strMethod = "set" + names[i].substring(0, 1).toUpperCase() + names[i].substring(1);
                this.methodMap.put(names[i], this.retrieveMethod(this.methods, strMethod));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Cannot create a method list of given : " + type.toString());
            }
        }
    }

    private void invokeSetterMethod(List<String> tokens, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            Method method = this.methodMap.get(names[i]);
            try {
                method.invoke(this.object, this.parsingFromString(tokens.get(i).trim(), this.fieldType[i]));
                continue;
            }
            catch (IllegalAccessException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
                continue;
            }
            catch (InvocationTargetException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
                continue;
            }
            catch (SecurityException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
        }
    }

    public T generateObject(Class<?> type, List<String> tokens, String[] names) {
        this.createObject(type);
        this.invokeSetterMethod(tokens, names);
        return (T)this.object;
    }

    public void generateGetterMethodMap(String[] names, T item) throws Exception {
        if (this.methods == null) {
            this.methods = item.getClass().getMethods();
            this.methodMap = new HashMap();
            try {
                for (int i = 0; i < names.length; ++i) {
                    String strMethod = "get" + names[i].substring(0, 1).toUpperCase() + names[i].substring(1);
                    this.methodMap.put(names[i], this.retrieveMethod(this.methods, strMethod));
                }
            }
            catch (Exception e) {
                throw new Exception("Cannot create a method list of given : " + item.toString());
            }
        }
    }

    public Object invokeGettterMethod(T item, String names) {
        Object value = null;
        try {
            value = this.methodMap.get(names).invoke(item, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return value;
    }

    public Object invokeGettterMethod(T item, String param, Map<String, Method> mapMethod) {
        Object value = null;
        try {
            value = mapMethod.get(param).invoke(item, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return value;
    }

    public void getFieldType(Class<?> type, String[] names) {
        this.fieldType = new Type[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                this.fieldType[i] = type.newInstance().getClass().getDeclaredField(names[i]).getType();
                continue;
            }
            catch (SecurityException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
                continue;
            }
            catch (NoSuchFieldException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
                continue;
            }
            catch (InstantiationException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
                continue;
            }
            catch (IllegalAccessException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
        }
    }

    public String[] getSqlTypeArray(String[] params, Object item) {
        String[] sqlTypes = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            try {
                sqlTypes[i] = item.getClass().getDeclaredField(params[i]).getType().getSimpleName().toString();
                continue;
            }
            catch (SecurityException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
                continue;
            }
            catch (NoSuchFieldException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
        }
        return sqlTypes;
    }

    private Object parsingFromString(String tokenValue, Type type) {
        Object parsingValue = null;
        parsingValue = type == String.class ? tokenValue : (type == Integer.TYPE ? Integer.valueOf(Integer.parseInt(tokenValue)) : (type == Double.TYPE ? Double.valueOf(Double.parseDouble(tokenValue)) : (type == Float.TYPE ? Float.valueOf(Float.parseFloat(tokenValue)) : (type == Long.TYPE ? Long.valueOf(Long.parseLong(tokenValue)) : (type == Character.TYPE ? Character.valueOf(tokenValue.charAt(0)) : (type == byte[].class ? (Object)tokenValue.getBytes() : (type == Boolean.TYPE ? Boolean.valueOf(tokenValue) : (type == Short.TYPE ? Short.valueOf(Short.parseShort(tokenValue)) : (type == BigDecimal.class ? new BigDecimal(tokenValue) : tokenValue)))))))));
        return parsingValue;
    }
}

