/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cryptography.impl.aria;

import egovframework.rte.fdl.cryptography.impl.aria.AnsiX923Padding;
import egovframework.rte.fdl.cryptography.impl.aria.CryptoPadding;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.util.Date;

public class ARIAEngine {
    private static final char[] HEX_DIGITS;
    private static final int[][] KRK;
    private static final byte[] S1;
    private static final byte[] S2;
    private static final byte[] X1;
    private static final byte[] X2;
    private static final int[] TS1;
    private static final int[] TS2;
    private static final int[] TX1;
    private static final int[] TX2;
    private static final int blockSize = 16;
    private static CryptoPadding padding;
    private int keySize = 0;
    private int numberOfRounds = 0;
    private byte[] masterKey = null;
    private int[] encRoundKeys = null;
    private int[] decRoundKeys = null;

    public ARIAEngine(int keySize) throws InvalidKeyException {
        this.setKeySize(keySize);
    }

    void reset() {
        this.keySize = 0;
        this.numberOfRounds = 0;
        this.masterKey = null;
        this.encRoundKeys = null;
        this.decRoundKeys = null;
    }

    int getKeySize() {
        return this.keySize;
    }

    void setKeySize(int keySize) throws InvalidKeyException {
        this.reset();
        if (keySize != 128 && keySize != 192 && keySize != 256) {
            throw new InvalidKeyException("keySize=" + keySize);
        }
        this.keySize = keySize;
        switch (keySize) {
            case 128: {
                this.numberOfRounds = 12;
                break;
            }
            case 192: {
                this.numberOfRounds = 14;
                break;
            }
            case 256: {
                this.numberOfRounds = 16;
            }
        }
    }

    void setKey(byte[] masterKey) throws InvalidKeyException {
        if (masterKey.length * 8 < this.keySize) {
            throw new InvalidKeyException("masterKey size=" + masterKey.length);
        }
        this.decRoundKeys = null;
        this.encRoundKeys = null;
        this.masterKey = (byte[])masterKey.clone();
    }

    void setupEncRoundKeys() throws InvalidKeyException {
        if (this.keySize == 0) {
            throw new InvalidKeyException("keySize");
        }
        if (this.masterKey == null) {
            throw new InvalidKeyException("masterKey");
        }
        if (this.encRoundKeys == null) {
            this.encRoundKeys = new int[4 * (this.numberOfRounds + 1)];
        }
        this.decRoundKeys = null;
        ARIAEngine.doEncKeySetup(this.masterKey, this.encRoundKeys, this.keySize);
    }

    void setupDecRoundKeys() throws InvalidKeyException {
        if (this.keySize == 0) {
            throw new InvalidKeyException("keySize");
        }
        if (this.encRoundKeys == null) {
            if (this.masterKey == null) {
                throw new InvalidKeyException("masterKey");
            }
            this.setupEncRoundKeys();
        }
        this.decRoundKeys = (int[])this.encRoundKeys.clone();
        ARIAEngine.doDecKeySetup(this.masterKey, this.decRoundKeys, this.keySize);
    }

    void setupRoundKeys() throws InvalidKeyException {
        this.setupDecRoundKeys();
    }

    private static void doCrypt(byte[] i, int ioffset, int[] rk, int nr, byte[] o, int ooffset) {
        int j = 0;
        int t0 = ARIAEngine.toInt(i[0 + ioffset], i[1 + ioffset], i[2 + ioffset], i[3 + ioffset]);
        int t1 = ARIAEngine.toInt(i[4 + ioffset], i[5 + ioffset], i[6 + ioffset], i[7 + ioffset]);
        int t2 = ARIAEngine.toInt(i[8 + ioffset], i[9 + ioffset], i[10 + ioffset], i[11 + ioffset]);
        int t3 = ARIAEngine.toInt(i[12 + ioffset], i[13 + ioffset], i[14 + ioffset], i[15 + ioffset]);
        for (int r = 1; r < nr / 2; ++r) {
            t0 ^= rk[j++];
            t1 ^= rk[j++];
            t2 ^= rk[j++];
            t3 ^= rk[j++];
            t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
            t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
            t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
            t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
            t1 = ARIAEngine.badc(t1);
            t2 = ARIAEngine.cdab(t2);
            t3 = ARIAEngine.dcba(t3);
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
            t0 ^= rk[j++];
            t1 ^= rk[j++];
            t2 ^= rk[j++];
            t3 ^= rk[j++];
            t0 = TX1[t0 >>> 24 & 0xFF] ^ TX2[t0 >>> 16 & 0xFF] ^ TS1[t0 >>> 8 & 0xFF] ^ TS2[t0 & 0xFF];
            t1 = TX1[t1 >>> 24 & 0xFF] ^ TX2[t1 >>> 16 & 0xFF] ^ TS1[t1 >>> 8 & 0xFF] ^ TS2[t1 & 0xFF];
            t2 = TX1[t2 >>> 24 & 0xFF] ^ TX2[t2 >>> 16 & 0xFF] ^ TS1[t2 >>> 8 & 0xFF] ^ TS2[t2 & 0xFF];
            t3 = TX1[t3 >>> 24 & 0xFF] ^ TX2[t3 >>> 16 & 0xFF] ^ TS1[t3 >>> 8 & 0xFF] ^ TS2[t3 & 0xFF];
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
            t3 = ARIAEngine.badc(t3);
            t0 = ARIAEngine.cdab(t0);
            t1 = ARIAEngine.dcba(t1);
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
        }
        t0 ^= rk[j++];
        t1 ^= rk[j++];
        t2 ^= rk[j++];
        t3 ^= rk[j++];
        t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
        t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
        t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
        t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = ARIAEngine.badc(t1);
        t2 = ARIAEngine.cdab(t2);
        t3 = ARIAEngine.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t0 ^= rk[j++];
        t1 ^= rk[j++];
        t2 ^= rk[j++];
        t3 ^= rk[j++];
        o[0 + ooffset] = (byte)(X1[0xFF & t0 >>> 24] ^ rk[j] >>> 24);
        o[1 + ooffset] = (byte)(X2[0xFF & t0 >>> 16] ^ rk[j] >>> 16);
        o[2 + ooffset] = (byte)(S1[0xFF & t0 >>> 8] ^ rk[j] >>> 8);
        o[3 + ooffset] = (byte)(S2[0xFF & t0] ^ rk[j]);
        o[4 + ooffset] = (byte)(X1[0xFF & t1 >>> 24] ^ rk[j + 1] >>> 24);
        o[5 + ooffset] = (byte)(X2[0xFF & t1 >>> 16] ^ rk[j + 1] >>> 16);
        o[6 + ooffset] = (byte)(S1[0xFF & t1 >>> 8] ^ rk[j + 1] >>> 8);
        o[7 + ooffset] = (byte)(S2[0xFF & t1] ^ rk[j + 1]);
        o[8 + ooffset] = (byte)(X1[0xFF & t2 >>> 24] ^ rk[j + 2] >>> 24);
        o[9 + ooffset] = (byte)(X2[0xFF & t2 >>> 16] ^ rk[j + 2] >>> 16);
        o[10 + ooffset] = (byte)(S1[0xFF & t2 >>> 8] ^ rk[j + 2] >>> 8);
        o[11 + ooffset] = (byte)(S2[0xFF & t2] ^ rk[j + 2]);
        o[12 + ooffset] = (byte)(X1[0xFF & t3 >>> 24] ^ rk[j + 3] >>> 24);
        o[13 + ooffset] = (byte)(X2[0xFF & t3 >>> 16] ^ rk[j + 3] >>> 16);
        o[14 + ooffset] = (byte)(S1[0xFF & t3 >>> 8] ^ rk[j + 3] >>> 8);
        o[15 + ooffset] = (byte)(S2[0xFF & t3] ^ rk[j + 3]);
    }

    void encrypt(byte[] i, int ioffset, byte[] o, int ooffset) throws InvalidKeyException {
        if (this.keySize == 0) {
            throw new InvalidKeyException("keySize");
        }
        if (this.encRoundKeys == null) {
            if (this.masterKey == null) {
                throw new InvalidKeyException("masterKey");
            }
            this.setupEncRoundKeys();
        }
        ARIAEngine.doCrypt(i, ioffset, this.encRoundKeys, this.numberOfRounds, o, ooffset);
    }

    byte[] encrypt(byte[] sbuffer, int ioffset) throws InvalidKeyException {
        byte[] inDataBuffer = padding.addPadding(sbuffer, 16);
        byte[] encryptBytes = new byte[inDataBuffer.length];
        int rt = inDataBuffer.length / 16;
        for (int j = 0; j < rt; ++j) {
            byte[] sSource = new byte[16];
            byte[] sTarget = new byte[16];
            System.arraycopy(inDataBuffer, j * 16, sSource, 0, 16);
            this.encrypt(sSource, ioffset, sTarget, 0);
            System.arraycopy(sTarget, 0, encryptBytes, j * 16, sTarget.length);
        }
        return encryptBytes;
    }

    void decrypt(byte[] i, int ioffset, byte[] o, int ooffset) throws InvalidKeyException {
        if (this.keySize == 0) {
            throw new InvalidKeyException("keySize");
        }
        if (this.decRoundKeys == null) {
            if (this.masterKey == null) {
                throw new InvalidKeyException("masterKey");
            }
            this.setupDecRoundKeys();
        }
        ARIAEngine.doCrypt(i, ioffset, this.decRoundKeys, this.numberOfRounds, o, ooffset);
    }

    byte[] decrypt(byte[] encryptBytes, int ioffset) throws InvalidKeyException {
        byte[] decryptBytes = new byte[encryptBytes.length];
        int rt = encryptBytes.length / 16;
        for (int j = 0; j < rt; ++j) {
            byte[] sSource = new byte[16];
            byte[] sTarget = new byte[16];
            System.arraycopy(encryptBytes, j * 16, sSource, 0, 16);
            this.decrypt(sSource, ioffset, sTarget, 0);
            System.arraycopy(sTarget, 0, decryptBytes, j * 16, 16);
        }
        return padding.removePadding(decryptBytes, 16);
    }

    private static void doEncKeySetup(byte[] mk, int[] rk, int keyBits) {
        int j = 0;
        int[] w0 = new int[4];
        int[] w1 = new int[4];
        int[] w2 = new int[4];
        int[] w3 = new int[4];
        w0[0] = ARIAEngine.toInt(mk[0], mk[1], mk[2], mk[3]);
        w0[1] = ARIAEngine.toInt(mk[4], mk[5], mk[6], mk[7]);
        w0[2] = ARIAEngine.toInt(mk[8], mk[9], mk[10], mk[11]);
        w0[3] = ARIAEngine.toInt(mk[12], mk[13], mk[14], mk[15]);
        int q = (keyBits - 128) / 64;
        int t0 = w0[0] ^ KRK[q][0];
        int t1 = w0[1] ^ KRK[q][1];
        int t2 = w0[2] ^ KRK[q][2];
        int t3 = w0[3] ^ KRK[q][3];
        t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
        t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
        t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
        t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = ARIAEngine.badc(t1);
        t2 = ARIAEngine.cdab(t2);
        t3 = ARIAEngine.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        if (keyBits > 128) {
            w1[0] = ARIAEngine.toInt(mk[16], mk[17], mk[18], mk[19]);
            w1[1] = ARIAEngine.toInt(mk[20], mk[21], mk[22], mk[23]);
            if (keyBits > 192) {
                w1[2] = ARIAEngine.toInt(mk[24], mk[25], mk[26], mk[27]);
                w1[3] = ARIAEngine.toInt(mk[28], mk[29], mk[30], mk[31]);
            } else {
                w1[3] = 0;
                w1[2] = 0;
            }
        } else {
            w1[3] = 0;
            w1[2] = 0;
            w1[1] = 0;
            w1[0] = 0;
        }
        w1[0] = w1[0] ^ t0;
        w1[1] = w1[1] ^ t1;
        w1[2] = w1[2] ^ t2;
        w1[3] = w1[3] ^ t3;
        t0 = w1[0];
        t1 = w1[1];
        t2 = w1[2];
        t3 = w1[3];
        q = q == 2 ? 0 : q + 1;
        t0 ^= KRK[q][0];
        t1 ^= KRK[q][1];
        t2 ^= KRK[q][2];
        t3 ^= KRK[q][3];
        t0 = TX1[t0 >>> 24 & 0xFF] ^ TX2[t0 >>> 16 & 0xFF] ^ TS1[t0 >>> 8 & 0xFF] ^ TS2[t0 & 0xFF];
        t1 = TX1[t1 >>> 24 & 0xFF] ^ TX2[t1 >>> 16 & 0xFF] ^ TS1[t1 >>> 8 & 0xFF] ^ TS2[t1 & 0xFF];
        t2 = TX1[t2 >>> 24 & 0xFF] ^ TX2[t2 >>> 16 & 0xFF] ^ TS1[t2 >>> 8 & 0xFF] ^ TS2[t2 & 0xFF];
        t3 = TX1[t3 >>> 24 & 0xFF] ^ TX2[t3 >>> 16 & 0xFF] ^ TS1[t3 >>> 8 & 0xFF] ^ TS2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t3 = ARIAEngine.badc(t3);
        t0 = ARIAEngine.cdab(t0);
        t1 = ARIAEngine.dcba(t1);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        w2[0] = t0 ^= w0[0];
        w2[1] = t1 ^= w0[1];
        w2[2] = t2 ^= w0[2];
        w2[3] = t3 ^= w0[3];
        q = q == 2 ? 0 : q + 1;
        t0 ^= KRK[q][0];
        t1 ^= KRK[q][1];
        t2 ^= KRK[q][2];
        t3 ^= KRK[q][3];
        t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
        t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
        t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
        t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = ARIAEngine.badc(t1);
        t2 = ARIAEngine.cdab(t2);
        t3 = ARIAEngine.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        w3[0] = t0 ^ w1[0];
        w3[1] = (t1 ^= t2) ^ w1[1];
        w3[2] = t2 ^ w1[2];
        w3[3] = t3 ^ w1[3];
        ARIAEngine.gsrk(w0, w1, 19, rk, j);
        ARIAEngine.gsrk(w1, w2, 19, rk, j += 4);
        ARIAEngine.gsrk(w2, w3, 19, rk, j += 4);
        ARIAEngine.gsrk(w3, w0, 19, rk, j += 4);
        ARIAEngine.gsrk(w0, w1, 31, rk, j += 4);
        ARIAEngine.gsrk(w1, w2, 31, rk, j += 4);
        ARIAEngine.gsrk(w2, w3, 31, rk, j += 4);
        ARIAEngine.gsrk(w3, w0, 31, rk, j += 4);
        ARIAEngine.gsrk(w0, w1, 67, rk, j += 4);
        ARIAEngine.gsrk(w1, w2, 67, rk, j += 4);
        ARIAEngine.gsrk(w2, w3, 67, rk, j += 4);
        ARIAEngine.gsrk(w3, w0, 67, rk, j += 4);
        ARIAEngine.gsrk(w0, w1, 97, rk, j += 4);
        j += 4;
        if (keyBits > 128) {
            ARIAEngine.gsrk(w1, w2, 97, rk, j);
            ARIAEngine.gsrk(w2, w3, 97, rk, j += 4);
            j += 4;
        }
        if (keyBits > 192) {
            ARIAEngine.gsrk(w3, w0, 97, rk, j);
            ARIAEngine.gsrk(w0, w1, 109, rk, j += 4);
        }
    }

    private static void doDecKeySetup(byte[] mk, int[] rk, int keyBits) {
        int a = 0;
        int[] t = new int[4];
        int z = 32 + keyBits / 8;
        ARIAEngine.swapBlocks(rk, 0, z);
        a += 4;
        z -= 4;
        while (a < z) {
            ARIAEngine.swapAndDiffuse(rk, a, z, t);
            a += 4;
            z -= 4;
        }
        ARIAEngine.diff(rk, a, t, 0);
        rk[a] = t[0];
        rk[a + 1] = t[1];
        rk[a + 2] = t[2];
        rk[a + 3] = t[3];
    }

    private static int toInt(byte b0, byte b1, byte b2, byte b3) {
        return (b0 & 0xFF) << 24 ^ (b1 & 0xFF) << 16 ^ (b2 & 0xFF) << 8 ^ b3 & 0xFF;
    }

    private static void toByteArray(int i, byte[] b, int offset) {
        b[offset] = (byte)(i >>> 24);
        b[offset + 1] = (byte)(i >>> 16);
        b[offset + 2] = (byte)(i >>> 8);
        b[offset + 3] = (byte)i;
    }

    private static int m(int t) {
        return 65793 * (t >>> 24 & 0xFF) ^ 0x1000101 * (t >>> 16 & 0xFF) ^ 0x1010001 * (t >>> 8 & 0xFF) ^ 0x1010100 * (t & 0xFF);
    }

    private static final int badc(int t) {
        return t << 8 & 0xFF00FF00 ^ t >>> 8 & 0xFF00FF;
    }

    private static final int cdab(int t) {
        return t << 16 & 0xFFFF0000 ^ t >>> 16 & 0xFFFF;
    }

    private static final int dcba(int t) {
        return (t & 0xFF) << 24 ^ (t & 0xFF00) << 8 ^ (t & 0xFF0000) >>> 8 ^ (t & 0xFF000000) >>> 24;
    }

    private static final void gsrk(int[] x, int[] y, int rot, int[] rk, int offset) {
        int q = 4 - rot / 32;
        int r = rot % 32;
        int s = 32 - r;
        rk[offset] = x[0] ^ y[q % 4] >>> r ^ y[(q + 3) % 4] << s;
        rk[offset + 1] = x[1] ^ y[(q + 1) % 4] >>> r ^ y[q % 4] << s;
        rk[offset + 2] = x[2] ^ y[(q + 2) % 4] >>> r ^ y[(q + 1) % 4] << s;
        rk[offset + 3] = x[3] ^ y[(q + 3) % 4] >>> r ^ y[(q + 2) % 4] << s;
    }

    private static final void diff(int[] i, int offset1, int[] o, int offset2) {
        int t0 = ARIAEngine.m(i[offset1]);
        int t1 = ARIAEngine.m(i[offset1 + 1]);
        int t2 = ARIAEngine.m(i[offset1 + 2]);
        int t3 = ARIAEngine.m(i[offset1 + 3]);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = ARIAEngine.badc(t1);
        t2 = ARIAEngine.cdab(t2);
        t3 = ARIAEngine.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        o[offset2] = t0;
        o[offset2 + 1] = t1 ^= t2;
        o[offset2 + 2] = t2;
        o[offset2 + 3] = t3;
    }

    private static final void swapBlocks(int[] arr, int offset1, int offset2) {
        for (int i = 0; i < 4; ++i) {
            int t = arr[offset1 + i];
            arr[offset1 + i] = arr[offset2 + i];
            arr[offset2 + i] = t;
        }
    }

    private static final void swapAndDiffuse(int[] arr, int offset1, int offset2, int[] tmp) {
        ARIAEngine.diff(arr, offset1, tmp, 0);
        ARIAEngine.diff(arr, offset2, arr, offset1);
        arr[offset2] = tmp[0];
        arr[offset2 + 1] = tmp[1];
        arr[offset2 + 2] = tmp[2];
        arr[offset2 + 3] = tmp[3];
    }

    private static void printBlock(PrintStream out, byte[] b) {
        int i;
        for (i = 0; i < 4; ++i) {
            ARIAEngine.byteToHex(out, b[i]);
        }
        out.print(" ");
        for (i = 4; i < 8; ++i) {
            ARIAEngine.byteToHex(out, b[i]);
        }
        out.print(" ");
        for (i = 8; i < 12; ++i) {
            ARIAEngine.byteToHex(out, b[i]);
        }
        out.print(" ");
        for (i = 12; i < 16; ++i) {
            ARIAEngine.byteToHex(out, b[i]);
        }
    }

    private static void printSBox(PrintStream out, byte[] box) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                ARIAEngine.byteToHex(out, box[16 * i + j]);
                out.print(" ");
            }
            out.println();
        }
    }

    private static void byteToHex(PrintStream out, byte b) {
        char[] buf = new char[]{HEX_DIGITS[b >>> 4 & 0xF], HEX_DIGITS[b & 0xF]};
        out.print(new String(buf));
    }

    private static void intToHex(PrintStream out, int i) {
        byte[] b = new byte[4];
        ARIAEngine.toByteArray(i, b, 0);
        ARIAEngine.byteToHex(out, b[0]);
        ARIAEngine.byteToHex(out, b[1]);
        ARIAEngine.byteToHex(out, b[2]);
        ARIAEngine.byteToHex(out, b[3]);
    }

    private static void printRoundKeys(PrintStream out, int[] roundKeys) {
        int i = 0;
        while (i < roundKeys.length) {
            out.print("* ");
            ARIAEngine.intToHex(out, roundKeys[i++]);
            out.print(" ");
            ARIAEngine.intToHex(out, roundKeys[i++]);
            out.print(" ");
            ARIAEngine.intToHex(out, roundKeys[i++]);
            out.print(" ");
            ARIAEngine.intToHex(out, roundKeys[i++]);
            out.print(" \n");
        }
    }

    public static void ARIA_test() throws InvalidKeyException {
        int i;
        int i2;
        int i3;
        byte[] p = new byte[16];
        byte[] c = new byte[16];
        byte[] mk = new byte[32];
        boolean flag = false;
        PrintStream out = System.out;
        ARIAEngine instance = new ARIAEngine(256);
        for (i3 = 0; i3 < 32; ++i3) {
            mk[i3] = 0;
        }
        for (i3 = 0; i3 < 16; ++i3) {
            p[i3] = 0;
        }
        out.println("BEGIN testing the roundtrip...");
        out.println("For key size of 256 bits, starting with the zero plaintext and the zero key, let's see if we may recover the plaintext by decrypting the encrypted ciphertext.");
        instance.setKey(mk);
        instance.setupRoundKeys();
        out.print("plaintext : ");
        ARIAEngine.printBlock(out, p);
        out.println();
        instance.encrypt(p, 0, c, 0);
        out.print("ciphertext: ");
        ARIAEngine.printBlock(out, c);
        out.println();
        instance.decrypt(c, 0, p, 0);
        out.print("decrypted : ");
        ARIAEngine.printBlock(out, p);
        out.println();
        flag = false;
        for (i3 = 0; i3 < 16; ++i3) {
            if (p[i3] == 0) continue;
            flag = true;
        }
        if (flag) {
            out.println("The result is incorrect!");
        } else {
            out.println("Okay.  The result is correct.");
        }
        out.println("END   testing the roundtrip.\n");
        int TEST_NUM = 0x800000;
        out.println("BEGIN speed measurement...");
        for (i2 = 0; i2 < 16; ++i2) {
            mk[i2] = (byte)i2;
        }
        out.println("  First, EncKeySetup():");
        out.print("  masterkey: ");
        ARIAEngine.printBlock(out, mk);
        out.println();
        instance.reset();
        instance.setKeySize(128);
        instance.setKey(mk);
        for (i2 = 0; i2 < 1000; ++i2) {
            instance.setupEncRoundKeys();
        }
        Date start = new Date();
        for (int i4 = 0; i4 < TEST_NUM; ++i4) {
            instance.setupEncRoundKeys();
        }
        Date fin = new Date();
        float lapse = (float)(fin.getTime() - start.getTime()) / 1000.0f;
        out.print("  time lapsed: ");
        out.print(lapse);
        out.println(" sec.");
        out.print("  speed      : ");
        out.print((float)(TEST_NUM * 128) / (lapse * 1024.0f * 1024.0f));
        out.println(" megabits/sec.\n");
        out.println("  Next, Crypt():");
        for (i = 0; i < 16; ++i) {
            p[i] = (byte)(i << 4 ^ i);
        }
        out.print("  plaintext : ");
        ARIAEngine.printBlock(out, p);
        out.println();
        for (i = 0; i < 1000; ++i) {
            instance.encrypt(p, 0, c, 0);
        }
        start = new Date();
        for (i = 0; i < TEST_NUM; ++i) {
            instance.encrypt(p, 0, c, 0);
        }
        fin = new Date();
        out.print("  ciphertext: ");
        ARIAEngine.printBlock(out, c);
        out.println();
        lapse = (float)(fin.getTime() - start.getTime()) / 1000.0f;
        out.print("  time lapsed: ");
        out.print(lapse);
        out.println(" sec.");
        out.print("  speed      : ");
        out.print((float)(TEST_NUM * 128) / (lapse * 1024.0f * 1024.0f));
        out.println(" megabits/sec.\n");
        out.println("  Finally, DecKeySetup():");
        for (i = 0; i < 1000; ++i) {
            instance.setupDecRoundKeys();
        }
        start = new Date();
        for (i = 0; i < TEST_NUM; ++i) {
            instance.setupDecRoundKeys();
        }
        fin = new Date();
        lapse = (float)(fin.getTime() - start.getTime()) / 1000.0f;
        out.print("  time lapsed: ");
        out.print(lapse);
        out.println(" sec.");
        out.print("  speed      : ");
        out.print((float)(TEST_NUM * 128) / (lapse * 1024.0f * 1024.0f));
        out.println(" megabits/sec.");
        out.println("END   speed measurement.");
    }

    public byte[] decrypt(byte[] encryptBytes, byte[] szKey) throws InvalidKeyException {
        this.setKey(szKey);
        this.setupRoundKeys();
        return this.decrypt(encryptBytes, 0);
    }

    public byte[] encrypt(byte[] sbuffer, byte[] szKey) throws InvalidKeyException {
        this.setKey(szKey);
        this.setupRoundKeys();
        return this.encrypt(sbuffer, 0);
    }

    public static void main(String[] args) {
        try {
            ARIAEngine.ARIA_test();
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
        }
    }

    static {
        int k;
        int s;
        int j;
        int p;
        int t;
        int i;
        int i2;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        KRK = new int[][]{{1367130551, 656542356, -32265240, -90542368}, {1840335564, -1641953248, -14110251, -279059792}, {-611174627, 556198256, 52729717, 82364686}};
        S1 = new byte[256];
        S2 = new byte[256];
        X1 = new byte[256];
        X2 = new byte[256];
        TS1 = new int[256];
        TS2 = new int[256];
        TX1 = new int[256];
        TX2 = new int[256];
        padding = null;
        padding = new AnsiX923Padding();
        int[] exp = new int[256];
        int[] log = new int[256];
        exp[0] = 1;
        for (i2 = 1; i2 < 256; ++i2) {
            int j2 = exp[i2 - 1] << 1 ^ exp[i2 - 1];
            if ((j2 & 0x100) != 0) {
                j2 ^= 0x11B;
            }
            exp[i2] = j2;
        }
        for (i2 = 1; i2 < 255; ++i2) {
            log[exp[i2]] = i2;
        }
        int[][] A = new int[][]{{1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}};
        int[][] B = new int[][]{{0, 1, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 1, 1}, {1, 0, 0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 0, 1, 1}};
        for (i = 0; i < 256; ++i) {
            t = 0;
            p = i == 0 ? 0 : exp[255 - log[i]];
            for (j = 0; j < 8; ++j) {
                s = 0;
                for (k = 0; k < 8; ++k) {
                    if ((p >>> 7 - k & 1) == 0) continue;
                    s ^= A[k][j];
                }
                t = t << 1 ^ s;
            }
            ARIAEngine.S1[i] = (byte)(t ^= 0x63);
            ARIAEngine.X1[t] = (byte)i;
        }
        for (i = 0; i < 256; ++i) {
            t = 0;
            p = i == 0 ? 0 : exp[247 * log[i] % 255];
            for (j = 0; j < 8; ++j) {
                s = 0;
                for (k = 0; k < 8; ++k) {
                    if ((p >>> k & 1) == 0) continue;
                    s ^= B[7 - j][k];
                }
                t = t << 1 ^ s;
            }
            ARIAEngine.S2[i] = (byte)(t ^= 0xE2);
            ARIAEngine.X2[t] = (byte)i;
        }
        for (i = 0; i < 256; ++i) {
            ARIAEngine.TS1[i] = 65793 * (S1[i] & 0xFF);
            ARIAEngine.TS2[i] = 0x1000101 * (S2[i] & 0xFF);
            ARIAEngine.TX1[i] = 0x1010001 * (X1[i] & 0xFF);
            ARIAEngine.TX2[i] = 0x1010100 * (X2[i] & 0xFF);
        }
    }
}

