/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.file.mapping;

import egovframework.rte.bat.core.reflection.EgovReflectionSupport;
import java.util.List;
import org.springframework.batch.item.file.transform.IncorrectTokenCountException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovObjectMapper<T>
implements InitializingBean {
    private Class<? extends T> type;
    private String[] names;
    private EgovReflectionSupport<?> egovReflectionSupport;

    public void setType(Class<? extends T> type) {
        this.type = type;
    }

    public void setNames(String[] names) {
        this.names = names;
        Assert.notNull((Object)names, (String)"Names must be non-null");
    }

    public T mapObject(List<String> tokens) {
        int tokenSize = tokens.size();
        if (this.names.length != tokenSize) {
            throw new IncorrectTokenCountException(this.names.length, tokenSize);
        }
        return (T)this.egovReflectionSupport.generateObject(this.type, tokens, this.names);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.type, (String)"The type must be set");
        Assert.notNull((Object)this.names, (String)"The names must be set");
        this.egovReflectionSupport = new EgovReflectionSupport();
        this.egovReflectionSupport.generateSetterMethodMap(this.type, this.names);
        this.egovReflectionSupport.getFieldType(this.type, this.names);
    }
}

