/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.WriteFailedException;
import org.springframework.batch.item.WriterNotOpenException;
import org.springframework.batch.item.file.FlatFileFooterCallback;
import org.springframework.batch.item.file.FlatFileHeaderCallback;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.batch.item.util.FileUtils;
import org.springframework.batch.support.transaction.TransactionAwareBufferedWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovPartitionFlatFileItemWriter<T>
extends ExecutionContextUserSupport
implements ResourceAwareItemWriterItemStream<T>,
InitializingBean {
    private static final boolean DEFAULT_TRANSACTIONAL = true;
    protected static final Log logger = LogFactory.getLog(EgovPartitionFlatFileItemWriter.class);
    private static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String WRITTEN_STATISTICS_NAME = "written";
    private static final String RESTART_DATA_NAME = "current.count";
    private Resource resource;
    private OutputState state = null;
    private LineAggregator<T> lineAggregator;
    private boolean saveState = true;
    private boolean shouldDeleteIfExists = true;
    private boolean shouldDeleteIfEmpty = false;
    private String encoding = "UTF-8";
    private FlatFileHeaderCallback headerCallback;
    private FlatFileFooterCallback footerCallback;
    private String lineSeparator = DEFAULT_LINE_SEPARATOR;
    private boolean transactional = true;
    private boolean append = false;
    private int fileCount = 0;
    private long fileOpenTime = 0L;
    private long fileCloseTime = 0L;

    public EgovPartitionFlatFileItemWriter() {
        this.setName(ClassUtils.getShortName(EgovPartitionFlatFileItemWriter.class));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.lineAggregator, (String)"A LineAggregator must be provided.");
        if (this.append) {
            this.shouldDeleteIfExists = false;
        }
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setLineAggregator(LineAggregator<T> lineAggregator) {
        this.lineAggregator = lineAggregator;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    public void setShouldDeleteIfExists(boolean shouldDeleteIfExists) {
        this.shouldDeleteIfExists = shouldDeleteIfExists;
    }

    public void setAppendAllowed(boolean append) {
        this.append = append;
        this.shouldDeleteIfExists = false;
    }

    public void setShouldDeleteIfEmpty(boolean shouldDeleteIfEmpty) {
        this.shouldDeleteIfEmpty = shouldDeleteIfEmpty;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void setHeaderCallback(FlatFileHeaderCallback headerCallback) {
        this.headerCallback = headerCallback;
    }

    public void setFooterCallback(FlatFileFooterCallback footerCallback) {
        this.footerCallback = footerCallback;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public synchronized void write(List<? extends T> items) throws Exception {
        if (!this.getOutputState().isInitialized()) {
            throw new WriterNotOpenException("Writer must be open before it can be written to");
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Writing to flat file with " + items.size() + " items."));
        }
        OutputState state = this.getOutputState();
        StringBuilder lines = new StringBuilder();
        int lineCount = 0;
        for (T item : items) {
            lines.append(this.lineAggregator.aggregate(item) + this.lineSeparator);
            ++lineCount;
        }
        try {
            state.write(lines.toString());
        }
        catch (IOException e) {
            throw new WriteFailedException("Could not write data.  The file may be corrupt.", (Throwable)e);
        }
        state.linesWritten += (long)lineCount;
    }

    public synchronized void close() {
        block10: {
            --this.fileCount;
            if (this.state != null && this.fileCount == 0) {
                try {
                    if (this.footerCallback != null && this.state.outputBufferedWriter != null) {
                        this.footerCallback.writeFooter(this.state.outputBufferedWriter);
                        this.state.outputBufferedWriter.flush();
                    }
                    this.fileCloseTime = this.resource.getFile().lastModified();
                    if (this.state.linesWritten != 0L || !this.shouldDeleteIfEmpty) break block10;
                    try {
                        this.resource.getFile().delete();
                    }
                    catch (IOException e) {
                        throw new ItemStreamException("Failed to delete empty file on close", (Throwable)e);
                    }
                }
                catch (ItemStreamException ie) {
                    throw ie;
                }
                catch (IOException e) {
                    throw new ItemStreamException("Failed to write footer before closing", (Throwable)e);
                }
                finally {
                    this.state.close();
                }
            }
        }
    }

    public synchronized void open(ExecutionContext executionContext) throws ItemStreamException {
        Assert.notNull((Object)this.resource, (String)"The resource must be set");
        ++this.fileCount;
        if (!this.getOutputState().isInitialized()) {
            this.doOpen(executionContext);
        }
    }

    private void doOpen(ExecutionContext executionContext) throws ItemStreamException {
        OutputState outputState = this.getOutputState();
        if (executionContext.containsKey(this.getKey(RESTART_DATA_NAME))) {
            outputState.restoreFrom(executionContext);
        }
        try {
            outputState.initializeBufferedWriter();
            this.fileOpenTime = this.resource.getFile().lastModified();
            if ((double)(this.fileOpenTime - this.fileCloseTime) / 1000.0 < 1.0) {
                throw new IOException("Failed to initialize writer");
            }
        }
        catch (IOException ioe) {
            throw new ItemStreamException("Failed to initialize writer", (Throwable)ioe);
        }
        if (outputState.lastMarkedByteOffsetPosition == 0L && !outputState.appending && this.headerCallback != null) {
            try {
                this.headerCallback.writeHeader(outputState.outputBufferedWriter);
                outputState.write(this.lineSeparator);
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not write headers.  The file may be corrupt.", (Throwable)e);
            }
        }
    }

    public void update(ExecutionContext executionContext) {
        if (this.state == null) {
            throw new ItemStreamException("ItemStream not open or already closed.");
        }
        Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
        if (this.saveState) {
            try {
                executionContext.putLong(this.getKey(RESTART_DATA_NAME), this.state.position());
            }
            catch (IOException e) {
                throw new ItemStreamException("ItemStream does not return current position properly", (Throwable)e);
            }
            executionContext.putLong(this.getKey(WRITTEN_STATISTICS_NAME), this.state.linesWritten);
        }
    }

    private OutputState getOutputState() {
        if (this.state == null) {
            File file;
            try {
                file = this.resource.getFile();
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not convert resource to file: [" + this.resource + "]", (Throwable)e);
            }
            Assert.state((!file.exists() || file.canWrite() ? 1 : 0) != 0, (String)("Resource is not writable: [" + this.resource + "]"));
            this.state = new OutputState();
            this.state.setDeleteIfExists(this.shouldDeleteIfExists);
            this.state.setAppendAllowed(this.append);
            this.state.setEncoding(this.encoding);
        }
        return this.state;
    }

    private class OutputState {
        private static final String DEFAULT_CHARSET = "UTF-8";
        private FileOutputStream os;
        Writer outputBufferedWriter;
        FileChannel fileChannel;
        String encoding = "UTF-8";
        boolean restarted = false;
        long lastMarkedByteOffsetPosition = 0L;
        long linesWritten = 0L;
        boolean shouldDeleteIfExists = true;
        boolean initialized = false;
        private boolean append = false;
        private boolean appending = false;

        private OutputState() {
        }

        public long position() throws IOException {
            long pos = 0L;
            if (this.fileChannel == null) {
                return 0L;
            }
            this.outputBufferedWriter.flush();
            pos = this.fileChannel.position();
            if (EgovPartitionFlatFileItemWriter.this.transactional) {
                pos += ((TransactionAwareBufferedWriter)this.outputBufferedWriter).getBufferSize();
            }
            return pos;
        }

        public void setAppendAllowed(boolean append) {
            this.append = append;
        }

        public void restoreFrom(ExecutionContext executionContext) {
            this.lastMarkedByteOffsetPosition = executionContext.getLong(EgovPartitionFlatFileItemWriter.this.getKey(EgovPartitionFlatFileItemWriter.RESTART_DATA_NAME));
            this.restarted = true;
        }

        public void setDeleteIfExists(boolean shouldDeleteIfExists) {
            this.shouldDeleteIfExists = shouldDeleteIfExists;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void close() {
            this.initialized = false;
            this.restarted = false;
            try {
                if (this.outputBufferedWriter != null) {
                    this.outputBufferedWriter.close();
                }
            }
            catch (IOException ioe) {
                throw new ItemStreamException("Unable to close the the ItemWriter", (Throwable)ioe);
            }
            finally {
                if (!EgovPartitionFlatFileItemWriter.this.transactional) {
                    this.closeStream();
                }
            }
        }

        private void closeStream() {
            try {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                }
            }
            catch (IOException ioe) {
                throw new ItemStreamException("Unable to close the the ItemWriter", (Throwable)ioe);
            }
            finally {
                if (this.os != null) {
                    try {
                        this.os.close();
                    }
                    catch (IOException ioe) {
                        logger.debug((Object)ioe);
                    }
                }
            }
        }

        public void write(String line) throws IOException {
            if (!this.initialized) {
                this.initializeBufferedWriter();
            }
            this.outputBufferedWriter.write(line);
            this.outputBufferedWriter.flush();
        }

        public void truncate() throws IOException {
            this.fileChannel.truncate(this.lastMarkedByteOffsetPosition);
            this.fileChannel.position(this.lastMarkedByteOffsetPosition);
        }

        private void initializeBufferedWriter() throws IOException {
            File file = EgovPartitionFlatFileItemWriter.this.resource.getFile();
            FileUtils.setUpOutputFile((File)file, (boolean)this.restarted, (boolean)this.append, (boolean)this.shouldDeleteIfExists);
            this.os = new FileOutputStream(file.getAbsolutePath(), true);
            this.fileChannel = this.os.getChannel();
            this.outputBufferedWriter = this.getBufferedWriter(this.fileChannel, this.encoding);
            this.outputBufferedWriter.flush();
            if (this.append && file.length() > 0L) {
                this.appending = true;
            }
            Assert.state((this.outputBufferedWriter != null ? 1 : 0) != 0);
            if (this.restarted) {
                this.checkFileSize();
                this.truncate();
            }
            this.initialized = true;
            this.linesWritten = 0L;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        private Writer getBufferedWriter(FileChannel fileChannel, String encoding) {
            try {
                Writer writer = Channels.newWriter((WritableByteChannel)fileChannel, encoding);
                if (EgovPartitionFlatFileItemWriter.this.transactional) {
                    return new TransactionAwareBufferedWriter(writer, new Runnable(){

                        public void run() {
                            OutputState.this.closeStream();
                        }
                    });
                }
                return new BufferedWriter(writer);
            }
            catch (UnsupportedCharsetException ucse) {
                throw new ItemStreamException("Bad encoding configuration for output file " + fileChannel, (Throwable)ucse);
            }
        }

        private void checkFileSize() throws IOException {
            long size = -1L;
            this.outputBufferedWriter.flush();
            size = this.fileChannel.size();
            if (size < this.lastMarkedByteOffsetPosition) {
                throw new ItemStreamException("Current file size is smaller than size at last commit");
            }
        }
    }
}

