/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.ptl.mvc.validation;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RteGenericValidator
implements Serializable {
    private static final long serialVersionUID = -7083990054872323995L;

    public static boolean isValidIdIhNum(String value) {
        String regex = "\\d{6}[1234]\\d{6}";
        if (!value.matches(regex)) {
            return false;
        }
        try {
            String strDate = value.substring(0, 6);
            strDate = (value.charAt(6) == '1' || value.charAt(6) == '2' ? "19" : "20") + strDate;
            strDate = strDate.substring(0, 4) + "/" + strDate.substring(4, 6) + "/" + strDate.substring(6, 8);
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
            Date date = dateformat.parse(strDate);
            String resultStr = dateformat.format(date);
            if (!resultStr.equals(strDate)) {
                return false;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        char[] charArray = value.toCharArray();
        long sum = 0L;
        int[] arrDivide = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 4, 5};
        for (int i = 0; i < charArray.length - 1; ++i) {
            sum += (long)(Integer.parseInt(String.valueOf(charArray[i])) * arrDivide[i]);
        }
        int checkdigit = (int)(11L - sum % 11L) % 10;
        return checkdigit == Integer.parseInt(String.valueOf(charArray[12]));
    }

    public static boolean isKorean(String value) {
        char[] charArray = value.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (Character.getType(charArray[i]) == 5) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnglish(String value) {
        char[] charArray = value.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (Character.getType(charArray[i]) == 1 || Character.getType(charArray[i]) == 2) continue;
            return false;
        }
        return true;
    }

    public static boolean isHtmlTag(String value) {
        Pattern re = Pattern.compile("<[^<|>]*>");
        Matcher m = re.matcher(value);
        return !m.find();
    }

    public static boolean checkLength(String password) {
        return password.length() >= 8 && password.length() <= 20;
    }

    public static boolean checkCharacterType(String password) {
        char[] charArray = password.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char ch = charArray[i];
            if (ch >= '!' && ch <= '~') continue;
            return false;
        }
        return true;
    }

    public static boolean checkSeries(String password) {
        int countSequence = 0;
        int countSame = 0;
        for (int i = 0; i < password.length() - 1; ++i) {
            char pass = password.charAt(i);
            char next = (char)(pass + '\u0001');
            countSequence = password.charAt(i + 1) == next ? ++countSequence : 0;
            countSame = pass == password.charAt(i + 1) ? ++countSame : 0;
            if (countSequence <= 2 && countSame <= 2) continue;
            return false;
        }
        return true;
    }
}

