/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.service.impl;

import egovframework.rte.itl.integration.type.ListType;
import egovframework.rte.itl.integration.type.PrimitiveType;
import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.webservice.service.EgovWebServiceClassLoader;
import egovframework.rte.itl.webservice.service.MessageConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConverterImpl
implements MessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageConverterImpl.class);
    private EgovWebServiceClassLoader classLoader;

    public MessageConverterImpl(EgovWebServiceClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        this.classLoader = classLoader;
    }

    @Override
    public Object convertToValueObject(Object source, Type type) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        LOGGER.debug("convertToValueObject(source = {}, type = {})", source, (Object)type);
        if (type instanceof PrimitiveType) {
            LOGGER.debug("Type is a Primitive Type");
            return source;
        }
        if (type instanceof ListType) {
            LOGGER.debug("Type is a List Type");
            ListType listType = (ListType)type;
            Object[] components = ((Collection)source).toArray();
            Class<?> arrayClass = this.classLoader.loadClass((Type)listType);
            Object array = Array.newInstance(arrayClass.getComponentType(), components.length);
            for (int i = 0; i < components.length; ++i) {
                Array.set(array, i, this.convertToValueObject(components[i], listType.getElementType()));
            }
            return array;
        }
        if (type instanceof RecordType) {
            LOGGER.debug("Type is a Record(Map) Type");
            RecordType recordType = (RecordType)type;
            Map map = (Map)source;
            Class<?> recordClass = this.classLoader.loadClass((Type)recordType);
            Object record = recordClass.newInstance();
            for (Map.Entry entry : map.entrySet()) {
                Object fieldValue = this.convertToValueObject(entry.getValue(), recordType.getFieldType((String)entry.getKey()));
                recordClass.getField((String)entry.getKey()).set(record, fieldValue);
            }
            return record;
        }
        LOGGER.error("Type is invalid");
        throw new InstantiationException();
    }

    @Override
    public Object convertToTypedObject(Object source, Type type) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, InstantiationException {
        LOGGER.debug("convertToTypedObject(source = {}, type = {})", source, (Object)type);
        if (type instanceof PrimitiveType) {
            LOGGER.debug("Type is a Primitive Type");
            return source;
        }
        if (type instanceof ListType) {
            LOGGER.debug("Type is a List Type");
            ListType listType = (ListType)type;
            Object[] components = (Object[])source;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object component : components) {
                list.add(this.convertToTypedObject(component, listType.getElementType()));
            }
            return list;
        }
        if (type instanceof RecordType) {
            LOGGER.debug("Type is a Record(Map) Type");
            RecordType recordType = (RecordType)type;
            Class<?> recordClass = this.classLoader.loadClass((Type)recordType);
            HashMap map = new HashMap();
            for (Map.Entry entry : recordType.getFieldTypes().entrySet()) {
                Object fieldValue = recordClass.getField((String)entry.getKey()).get(source);
                map.put(entry.getKey(), this.convertToTypedObject(fieldValue, (Type)entry.getValue()));
            }
            return map;
        }
        LOGGER.error("Type is invalid");
        throw new InstantiationException();
    }
}

