/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.securedobject.impl;

import egovframework.rte.fdl.security.config.SecuredObjectConfig;
import egovframework.rte.fdl.security.securedobject.impl.SelfRegexRequestMatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.StringUtils;

public class SecuredObjectDAO
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecuredObjectDAO.class);
    public static final String DEF_ROLES_AND_URL_QUERY = "SELECT a.resource_pattern url, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'url' ORDER BY a.sort_order ";
    public static final String DEF_ROLES_AND_METHOD_QUERY = "SELECT a.resource_pattern method, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'method' ORDER BY a.sort_order ";
    public static final String DEF_ROLES_AND_POINTCUT_QUERY = "SELECT a.resource_pattern pointcut, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'pointcut' ORDER BY a.sort_order ";
    public static final String DEF_REGEX_MATCHED_REQUEST_MAPPING_QUERY_ORACLE10G = "SELECT a.resource_pattern uri, b.authority authority FROM secured_resources a, secured_resources_role b WHERE a.resource_id = b.resource_id AND a.resource_id =   ( SELECT resource_id FROM     ( SELECT resource_id, ROW_NUMBER() OVER (ORDER BY sort_order) resource_order FROM secured_resources c       WHERE REGEXP_LIKE ( :url, c.resource_pattern )       AND c.resource_type = 'url'       ORDER BY c.sort_order )    WHERE resource_order = 1 ) ";
    public static final String DEF_HIERARCHICAL_ROLES_QUERY = "SELECT a.child_role child, a.parent_role parent FROM ROLES_HIERARCHY a LEFT JOIN ROLES_HIERARCHY b on (a.child_role = b.parent_role) ";
    private String sqlRolesAndUrl = "SELECT a.resource_pattern url, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'url' ORDER BY a.sort_order ";
    private String sqlRolesAndMethod = "SELECT a.resource_pattern method, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'method' ORDER BY a.sort_order ";
    private String sqlRolesAndPointcut = "SELECT a.resource_pattern pointcut, b.authority authority FROM SECURED_RESOURCES a, SECURED_RESOURCES_ROLE b WHERE a.resource_id = b.resource_id AND a.resource_type = 'pointcut' ORDER BY a.sort_order ";
    private String sqlRegexMatchedRequestMapping = "SELECT a.resource_pattern uri, b.authority authority FROM secured_resources a, secured_resources_role b WHERE a.resource_id = b.resource_id AND a.resource_id =   ( SELECT resource_id FROM     ( SELECT resource_id, ROW_NUMBER() OVER (ORDER BY sort_order) resource_order FROM secured_resources c       WHERE REGEXP_LIKE ( :url, c.resource_pattern )       AND c.resource_type = 'url'       ORDER BY c.sort_order )    WHERE resource_order = 1 ) ";
    private String sqlHierarchicalRoles = "SELECT a.child_role child, a.parent_role parent FROM ROLES_HIERARCHY a LEFT JOIN ROLES_HIERARCHY b on (a.child_role = b.parent_role) ";
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private ApplicationContext context;

    public void setDataSource(DataSource dataSource) {
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    @PostConstruct
    public void securedObjectConfigInit() {
        if (this.context.getBeanNamesForType(SecuredObjectConfig.class).length > 0) {
            SecuredObjectConfig config = (SecuredObjectConfig)this.context.getBean(SecuredObjectConfig.class);
            if (StringUtils.hasText((String)config.getSqlRolesAndUrl())) {
                this.sqlRolesAndUrl = config.getSqlRolesAndUrl();
            }
            if (StringUtils.hasText((String)config.getSqlRolesAndMethod())) {
                this.sqlRolesAndMethod = config.getSqlRolesAndMethod();
            }
            if (StringUtils.hasText((String)config.getSqlRolesAndPointcut())) {
                this.sqlRolesAndPointcut = config.getSqlRolesAndPointcut();
            }
            if (StringUtils.hasText((String)config.getSqlRegexMatchedRequestMapping())) {
                this.sqlRegexMatchedRequestMapping = config.getSqlRegexMatchedRequestMapping();
            }
            if (StringUtils.hasText((String)config.getSqlHierarchicalRoles())) {
                this.sqlHierarchicalRoles = config.getSqlHierarchicalRoles();
            }
        }
    }

    public String getSqlRolesAndUrl() {
        return this.sqlRolesAndUrl;
    }

    public void setSqlRolesAndUrl(String sqlRolesAndUrl) {
        this.sqlRolesAndUrl = sqlRolesAndUrl;
    }

    public String getSqlRolesAndMethod() {
        return this.sqlRolesAndMethod;
    }

    public void setSqlRolesAndMethod(String sqlRolesAndMethod) {
        this.sqlRolesAndMethod = sqlRolesAndMethod;
    }

    public String getSqlRolesAndPointcut() {
        return this.sqlRolesAndPointcut;
    }

    public void setSqlRolesAndPointcut(String sqlRolesAndPointcut) {
        this.sqlRolesAndPointcut = sqlRolesAndPointcut;
    }

    public String getSqlRegexMatchedRequestMapping() {
        return this.sqlRegexMatchedRequestMapping;
    }

    public void setSqlRegexMatchedRequestMapping(String sqlRegexMatchedRequestMapping) {
        this.sqlRegexMatchedRequestMapping = sqlRegexMatchedRequestMapping;
    }

    public String getSqlHierarchicalRoles() {
        return this.sqlHierarchicalRoles;
    }

    public void setSqlHierarchicalRoles(String sqlHierarchicalRoles) {
        this.sqlHierarchicalRoles = sqlHierarchicalRoles;
    }

    public LinkedHashMap<Object, List<ConfigAttribute>> getRolesAndResources(String resourceType, String requestMatcherType) throws Exception {
        String sqlRolesAndResources;
        LinkedHashMap<Object, List<ConfigAttribute>> resourcesMap = new LinkedHashMap<Object, List<ConfigAttribute>>();
        boolean isResourcesUrl = true;
        if ("method".equals(resourceType)) {
            sqlRolesAndResources = this.getSqlRolesAndMethod();
            isResourcesUrl = false;
        } else if ("pointcut".equals(resourceType)) {
            sqlRolesAndResources = this.getSqlRolesAndPointcut();
            isResourcesUrl = false;
        } else {
            sqlRolesAndResources = this.getSqlRolesAndUrl();
        }
        List resultList = this.namedParameterJdbcTemplate.queryForList(sqlRolesAndResources, new HashMap());
        Iterator itr = resultList.iterator();
        String preResource = null;
        while (itr.hasNext()) {
            Map tempMap = (Map)itr.next();
            String presentResourceStr = (String)tempMap.get(resourceType);
            Object presentResource = isResourcesUrl ? (requestMatcherType.equalsIgnoreCase("regex") ? new SelfRegexRequestMatcher(presentResourceStr, null) : (requestMatcherType.equalsIgnoreCase("ciRegex") ? new SelfRegexRequestMatcher(presentResourceStr, null, true) : new AntPathRequestMatcher(presentResourceStr))) : presentResourceStr;
            LinkedList<SecurityConfig> configList = new LinkedList<SecurityConfig>();
            if (preResource != null && presentResourceStr.equals(preResource)) {
                List<ConfigAttribute> preAuthList = resourcesMap.get(presentResource);
                for (SecurityConfig securityConfig : preAuthList) {
                    configList.add(securityConfig);
                }
            }
            configList.add(new SecurityConfig((String)tempMap.get("authority")));
            resourcesMap.put(presentResource, configList);
            preResource = presentResourceStr;
        }
        return resourcesMap;
    }

    public LinkedHashMap<Object, List<ConfigAttribute>> getRolesAndUrl(String requestMatcherType) throws Exception {
        return this.getRolesAndResources("url", requestMatcherType);
    }

    public LinkedHashMap<Object, List<ConfigAttribute>> getRolesAndMethod() throws Exception {
        return this.getRolesAndResources("method", null);
    }

    public LinkedHashMap<Object, List<ConfigAttribute>> getRolesAndPointcut() throws Exception {
        return this.getRolesAndResources("pointcut", null);
    }

    public List<ConfigAttribute> getRegexMatchedRequestMapping(String url) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("url", url);
        List resultList = this.namedParameterJdbcTemplate.queryForList(this.getSqlRegexMatchedRequestMapping(), paramMap);
        Iterator itr = resultList.iterator();
        LinkedList<ConfigAttribute> configList = new LinkedList<ConfigAttribute>();
        while (itr.hasNext()) {
            Map tempMap = (Map)itr.next();
            configList.add((ConfigAttribute)new SecurityConfig((String)tempMap.get("authority")));
        }
        if (configList.size() > 0) {
            LOGGER.debug("Request Uri : {}, matched Uri : {}, mapping Roles : {}", new Object[]{url, ((Map)resultList.get(0)).get("uri"), configList});
        }
        return configList;
    }

    public String getHierarchicalRoles() throws Exception {
        List resultList = this.namedParameterJdbcTemplate.queryForList(this.getSqlHierarchicalRoles(), new HashMap());
        Iterator itr = resultList.iterator();
        StringBuffer concatedRoles = new StringBuffer();
        while (itr.hasNext()) {
            Map tempMap = (Map)itr.next();
            concatedRoles.append(tempMap.get("child"));
            concatedRoles.append(" > ");
            concatedRoles.append(tempMap.get("parent"));
            concatedRoles.append("\n");
        }
        return concatedRoles.toString();
    }
}

