/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.intercept;

import egovframework.rte.fdl.security.securedobject.EgovSecuredObjectService;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.security.access.ConfigAttribute;

public class MethodResourcesMapFactoryBean
implements FactoryBean<LinkedHashMap<String, List<ConfigAttribute>>> {
    private String resourceType;
    private EgovSecuredObjectService securedObjectService;
    private LinkedHashMap<String, List<ConfigAttribute>> resourcesMap;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setSecuredObjectService(EgovSecuredObjectService securedObjectService) {
        this.securedObjectService = securedObjectService;
    }

    public void init() throws Exception {
        if ("method".equals(this.resourceType)) {
            this.resourcesMap = this.securedObjectService.getRolesAndMethod();
        } else if ("pointcut".equals(this.resourceType)) {
            this.resourcesMap = this.securedObjectService.getRolesAndPointcut();
        } else {
            throw new Exception("resourceType must be 'method' or 'pointcut'");
        }
    }

    public LinkedHashMap<String, List<ConfigAttribute>> getObject() throws Exception {
        if (this.resourcesMap == null) {
            this.init();
        }
        return this.resourcesMap;
    }

    public Class<LinkedHashMap> getObjectType() {
        return LinkedHashMap.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

