/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.xml;

import egovframework.rte.fdl.xml.SharedObject;
import egovframework.rte.fdl.xml.XmlConfig;
import egovframework.rte.fdl.xml.exception.ValidatorException;
import java.io.CharArrayReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.transform.JDOMSource;
import org.jdom2.xpath.XPath;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.xml.sax.InputSource;

public abstract class AbstractXMLUtility {
    private String fileName = null;
    private String schmafileName = null;
    private String xmlValue = null;
    private ApplicationContext context = new FileSystemXmlApplicationContext(this.configPath);
    private XmlConfig xmlConfig = (XmlConfig)this.context.getBean("xmlconfig");
    private String savedPath = this.xmlConfig.getXmlpath();
    private String configPath = "classpath*:spring/egovxmlCfg.xml";

    public void setXMLFile(String fileName) {
        this.fileName = fileName;
    }

    public String getXMLFile() {
        return this.fileName;
    }

    public void setSCHEMAFile(String schmafileName) {
        this.schmafileName = schmafileName;
    }

    public String getSCHEMAFile() {
        return this.schmafileName;
    }

    public void setXML(String xmlValue) {
        this.xmlValue = xmlValue;
    }

    public String getXML() {
        return this.xmlValue;
    }

    protected InputSource stringToInputSource() {
        char[] xml = this.getXML().toCharArray();
        CharArrayReader reader = new CharArrayReader(xml);
        return new InputSource(reader);
    }

    public abstract boolean parse(boolean var1) throws ValidatorException;

    protected void makeErrorMessage(Set<?> errorReport) throws ValidatorException {
        StringBuffer errorMessage = new StringBuffer();
        Iterator<?> iterator = errorReport.iterator();
        while (iterator.hasNext()) {
            String tmp = (String)iterator.next();
            errorMessage.append(tmp);
            errorMessage.append("<br/>");
            iterator.remove();
        }
        throw new ValidatorException(errorMessage.toString());
    }

    public List<?> getResult(Document doc, String exps) throws JDOMException {
        XPath xPath = XPath.newInstance((String)exps);
        return xPath.selectNodes((Object)doc);
    }

    public void addElement(Document doc, String addNDName, List<?> list, String path) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        StreamResult sTResult = null;
        FileOutputStream fos = null;
        Element root = doc.getRootElement();
        this.addNode(root, addNDName, list);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer serializer = transformerFactory.newTransformer();
        serializer.setOutputProperty("encoding", "euc-kr");
        serializer.setOutputProperty("indent", "yes");
        if (path != null) {
            fos = new FileOutputStream(path);
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        } else {
            fos = new FileOutputStream(this.savedPath + "addElement.xml");
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        }
    }

    public void addTextElement(Document doc, String addNDName, List<?> list, String path) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        StreamResult sTResult = null;
        FileOutputStream fos = null;
        Element root = doc.getRootElement();
        this.addTextNode(root, addNDName, list);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer serializer = transformerFactory.newTransformer();
        serializer.setOutputProperty("encoding", "euc-kr");
        serializer.setOutputProperty("indent", "yes");
        if (path != null) {
            fos = new FileOutputStream(path);
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        } else {
            fos = new FileOutputStream(this.savedPath + "addElement.xml");
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        }
    }

    public void addTextNode(Element element, String addNDName, List<?> list) {
        block5: {
            block4: {
                List childList = element.getChildren();
                if (childList.size() == 0) break block4;
                for (int yy = 0; yy < childList.size(); ++yy) {
                    Element tmp = (Element)childList.get(yy);
                    if (tmp.getName().equals(addNDName)) {
                        for (int tt = 0; tt < list.size(); ++tt) {
                            SharedObject sobj = (SharedObject)list.get(tt);
                            tmp.addContent((String)sobj.getValue());
                        }
                    }
                    this.addTextNode(tmp, addNDName, list);
                }
                break block5;
            }
            if (!element.getName().equals(addNDName)) break block5;
            for (int tt = 0; tt < list.size(); ++tt) {
                SharedObject sobj = (SharedObject)list.get(tt);
                element.addContent((String)sobj.getValue());
            }
        }
    }

    public void updTextElement(Document doc, List<?> list, String path) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        StreamResult sTResult = null;
        FileOutputStream fos = null;
        Element root = doc.getRootElement();
        this.updTextNode(root, list);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer serializer = transformerFactory.newTransformer();
        serializer.setOutputProperty("encoding", "euc-kr");
        serializer.setOutputProperty("indent", "yes");
        if (path != null) {
            fos = new FileOutputStream(path);
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        } else {
            fos = new FileOutputStream(this.savedPath + "updTEXT.xml");
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        }
    }

    public void updTextNode(Element element, List<?> list) {
        List childList = element.getChildren();
        if (childList.size() != 0) {
            for (int yy = 0; yy < childList.size(); ++yy) {
                Element tmp = (Element)childList.get(yy);
                for (int tt = 0; tt < list.size(); ++tt) {
                    SharedObject sobj = (SharedObject)list.get(tt);
                    if (!tmp.getValue().equals(sobj.getKey())) continue;
                    tmp.setText((String)sobj.getValue());
                    break;
                }
                this.updTextNode(tmp, list);
            }
        } else {
            for (int tt = 0; tt < list.size(); ++tt) {
                SharedObject sobj = (SharedObject)list.get(tt);
                if (!element.getValue().equals(sobj.getKey())) continue;
                element.setText((String)sobj.getValue());
                break;
            }
        }
    }

    public void addNode(Element element, String addNDName, List<?> list) {
        block5: {
            block4: {
                List childList = element.getChildren();
                if (childList.size() == 0) break block4;
                for (int yy = 0; yy < childList.size(); ++yy) {
                    Element tmp = (Element)childList.get(yy);
                    if (tmp.getName().equals(addNDName)) {
                        for (int tt = 0; tt < list.size(); ++tt) {
                            SharedObject sobj = (SharedObject)list.get(tt);
                            Element enew = new Element(sobj.getKey());
                            enew.setText((String)sobj.getValue());
                            tmp.addContent((Content)enew);
                        }
                    }
                    this.addNode(tmp, addNDName, list);
                }
                break block5;
            }
            if (!element.getName().equals(addNDName)) break block5;
            for (int tt = 0; tt < list.size(); ++tt) {
                SharedObject sobj = (SharedObject)list.get(tt);
                Element enew = new Element(sobj.getKey());
                enew.setText((String)sobj.getValue());
                element.addContent((Content)enew);
            }
        }
    }

    public void removeNode(Element element, String name) {
        List list = element.getChildren();
        if (list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element tmp = (Element)list.get(i);
                if (tmp.getName().equals(name)) {
                    tmp.getParentElement().removeChild(name);
                    continue;
                }
                this.removeNode(tmp, name);
            }
        } else if (element.getName().equals(name)) {
            element.getParentElement().removeChild(name);
        }
    }

    public void delElement(Document doc, String nodeName, String path) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        StreamResult sTResult = null;
        FileOutputStream fos = null;
        Element element = doc.getRootElement();
        this.removeNode(element, nodeName);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer serializer = transformerFactory.newTransformer();
        serializer.setOutputProperty("encoding", "euc-kr");
        serializer.setOutputProperty("indent", "yes");
        if (path != null) {
            fos = new FileOutputStream(path);
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        } else {
            fos = new FileOutputStream(this.savedPath + "delXML.xml");
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        }
    }

    public void chgNode(Element element, String oldNode, String newNodename) {
        List list = element.getChildren();
        if (list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element tmp = (Element)list.get(i);
                if (element.getName().equals(oldNode)) {
                    element.setName(newNodename);
                    continue;
                }
                this.chgNode(tmp, oldNode, newNodename);
            }
        } else if (element.getName().equals(oldNode)) {
            element.setName(newNodename);
        }
    }

    public void updElement(Document doc, String oldNodename, String newNodeName, String path) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        StreamResult sTResult = null;
        FileOutputStream fos = null;
        Element root = doc.getRootElement();
        this.chgNode(root, oldNodename, newNodeName);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer serializer = transformerFactory.newTransformer();
        serializer.setOutputProperty("encoding", "euc-kr");
        serializer.setOutputProperty("indent", "yes");
        if (path != null) {
            fos = new FileOutputStream(path);
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        } else {
            fos = new FileOutputStream(this.savedPath + "updElement.xml");
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        }
    }

    public void createNewXML(Document doc, String newNodeName, List<?> list, String path) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        StreamResult sTResult = null;
        FileOutputStream fos = null;
        Element root = new Element(newNodeName);
        doc.addContent((Content)root);
        this.createXML(root, list);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer serializer = transformerFactory.newTransformer();
        serializer.setOutputProperty("encoding", "euc-kr");
        serializer.setOutputProperty("indent", "yes");
        if (path != null) {
            fos = new FileOutputStream(path);
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        } else {
            fos = new FileOutputStream(this.savedPath + "newXML.xml");
            sTResult = new StreamResult(fos);
            serializer.transform((Source)new JDOMSource(doc), sTResult);
            fos.close();
        }
    }

    public void createXML(Element root, List<?> list) {
        for (int i = 0; i < list.size(); ++i) {
            SharedObject sobj = (SharedObject)list.get(i);
            Element elm = new Element(sobj.getKey());
            elm.setText((String)sobj.getValue());
            root.addContent((Content)elm);
        }
    }
}

