/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.property.db.initializer;

import egovframework.rte.fdl.property.db.DbPropertySource;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.web.context.WebApplicationContext;

public class DBPropertySourceInitializer<T>
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String PROPERTY_SOUCE_CONFIG_LOCATION = "propertySourceConfigLocation";

    public void initialize(ConfigurableApplicationContext ctx) {
        String xmlContextPath = ((WebApplicationContext)ctx).getServletContext().getInitParameter(PROPERTY_SOUCE_CONFIG_LOCATION);
        MutablePropertySources propertySources = ctx.getEnvironment().getPropertySources();
        propertySources.addFirst(this.getPropertySource(xmlContextPath));
    }

    public PropertySource<?> getPropertySource(String xmlContextPath) {
        ClassPathXmlApplicationContext propertySourceContext = new ClassPathXmlApplicationContext(xmlContextPath);
        PropertySource propertySource = (PropertySource)propertySourceContext.getBean(DbPropertySource.class);
        propertySourceContext.close();
        return propertySource;
    }
}

