/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cryptography.impl;

import egovframework.rte.fdl.cryptography.EgovARIACryptoService;
import egovframework.rte.fdl.cryptography.EgovPasswordEncoder;
import egovframework.rte.fdl.cryptography.impl.ARIACipher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.ReflectionUtils;

public class EgovARIACryptoServiceImpl
implements EgovARIACryptoService {
    private final Base64 base64 = new Base64();
    private Logger logger = Logger.getLogger(this.getClass());
    private EgovPasswordEncoder passwordEncoder;
    private int blockSize = 1024;

    @Required
    public void setPasswordEncoder(EgovPasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
        this.logger.debug((Object)("passwordEncoder's algorithm : " + passwordEncoder.getAlgorithm()));
    }

    public void setBlockSize(int blockSize) {
        if (blockSize % 16 != 0) {
            blockSize += 16 - blockSize % 16;
        }
        this.blockSize = blockSize;
    }

    public BigDecimal encrypt(BigDecimal number, String password) {
        throw new UnsupportedOperationException("Unsupported method.. (ARIA Cryptography service doesn't support BigDecimal en/decryption)");
    }

    public byte[] encrypt(byte[] data, String password) {
        if (this.passwordEncoder.checkPassword(password)) {
            ARIACipher cipher = new ARIACipher();
            cipher.setPassword(password);
            return cipher.encrypt(data);
        }
        this.logger.error((Object)"password not matched!!!");
        throw new IllegalArgumentException("password not matched!!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(File srcFile, String password, File trgtFile) {
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        String fileString = new String();
        byte[] buffer = null;
        if (this.passwordEncoder.checkPassword(password)) {
            ARIACipher cipher = new ARIACipher();
            cipher.setPassword(password);
            try {
                fis = new FileInputStream(srcFile);
                baos = new ByteArrayOutputStream();
                buffer = new byte[this.blockSize];
                this.logger.debug((Object)"blockSize = {}", (Object)this.blockSize);
                int len = 0;
                while ((len = fis.read(buffer)) != -1) {
                    if (len < this.blockSize) {
                        byte[] tmp = new byte[len];
                        System.arraycopy(buffer, 0, tmp, 0, len);
                        baos.write(tmp, 0, len);
                        continue;
                    }
                    baos.write(buffer, 0, len);
                }
                byte[] fileArray = baos.toByteArray();
                fileString = new String(Base64.encodeBase64((byte[])fileArray));
                byte[] enc = cipher.encrypt(fileString.getBytes("UTF-8"));
                String encString = Base64.encodeBase64String((byte[])enc);
                FileUtils.writeStringToFile((File)trgtFile, (String)encString, (String)"UTF-8");
            }
            catch (FileNotFoundException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
            catch (IOException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            this.logger.error((Object)"password not matched!!!");
            throw new IllegalArgumentException("password not matched!!!");
        }
    }

    public BigDecimal decrypt(BigDecimal encryptedNumber, String password) {
        throw new UnsupportedOperationException("Unsupported method.. (ARIA Cryptography service doesn't support BigDecimal en/decryption)");
    }

    public byte[] decrypt(byte[] encryptedData, String password) {
        if (this.passwordEncoder.checkPassword(password)) {
            ARIACipher cipher = new ARIACipher();
            cipher.setPassword(password);
            return cipher.decrypt(encryptedData);
        }
        this.logger.error((Object)"password not matched!!!");
        throw new IllegalArgumentException("password not matched!!!");
    }

    public void decrypt(File encryptedFile, String password, File trgtFile) {
        if (this.passwordEncoder.checkPassword(password)) {
            ARIACipher cipher = new ARIACipher();
            cipher.setPassword(password);
            try {
                String readEncString = FileUtils.readFileToString((File)encryptedFile, (String)"UTF-8");
                byte[] decEnc = Base64.decodeBase64((String)readEncString);
                byte[] dec = cipher.decrypt(decEnc);
                String decBase64String = new String(dec, "UTF-8");
                byte[] data = Base64.decodeBase64((String)decBase64String);
                FileUtils.writeByteArrayToFile((File)trgtFile, (byte[])data);
            }
            catch (FileNotFoundException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
            catch (IOException e) {
                ReflectionUtils.handleReflectionException((Exception)e);
            }
        } else {
            this.logger.error((Object)"password not matched!!!");
            throw new IllegalArgumentException("password not matched!!!");
        }
    }
}

