/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cryptography.impl;

import egovframework.rte.fdl.cryptography.EgovDigestService;
import org.apache.log4j.Logger;
import org.jasypt.digest.StandardByteDigester;

public class EgovDigestServiceImpl
implements EgovDigestService {
    private Logger logger = Logger.getLogger(this.getClass());
    private String algorithm = "SHA-256";
    private boolean plainDigest = false;
    private int strongIterations = 1000;
    private int strongSaltSizeBytes = 8;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setPlainDigest(boolean plainDigest) {
        this.plainDigest = plainDigest;
    }

    public boolean isPlainDigest() {
        return this.plainDigest;
    }

    public byte[] digest(byte[] data) {
        StandardByteDigester digester = new StandardByteDigester();
        digester.setAlgorithm(this.algorithm);
        this.logger.debug((Object)("Digest's algorithm : " + this.algorithm));
        if (this.plainDigest) {
            digester.setIterations(1);
            digester.setSaltSizeBytes(0);
        } else {
            digester.setIterations(this.strongIterations);
            digester.setSaltSizeBytes(this.strongSaltSizeBytes);
        }
        return digester.digest(data);
    }

    public boolean matches(byte[] messageByte, byte[] digestByte) {
        StandardByteDigester digester = new StandardByteDigester();
        digester.setAlgorithm(this.algorithm);
        this.logger.debug((Object)("Digest's algorithm : " + this.algorithm));
        if (this.plainDigest) {
            digester.setIterations(1);
            digester.setSaltSizeBytes(0);
        } else {
            digester.setIterations(this.strongIterations);
            digester.setSaltSizeBytes(this.strongSaltSizeBytes);
        }
        return digester.matches(messageByte, digestByte);
    }
}

