/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cmmn.aspect;

import egovframework.rte.fdl.cmmn.exception.BaseException;
import egovframework.rte.fdl.cmmn.exception.EgovBizException;
import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.cmmn.exception.manager.ExceptionHandlerService;
import java.util.Locale;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class ExceptionTransfer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionTransfer.class);
    @Resource(name="messageSource")
    private MessageSource messageSource;
    private ExceptionHandlerService[] exceptionHandlerServices;
    private PathMatcher pm = new AntPathMatcher();

    public void setExceptionHandlerService(ExceptionHandlerService[] exceptionHandlerServices) {
        this.exceptionHandlerServices = exceptionHandlerServices;
        if (this.exceptionHandlerServices != null) {
            LOGGER.debug("count of ExceptionHandlerServices = {}", (Object)exceptionHandlerServices.length);
        }
    }

    public int countOfTheExceptionHandlerService() {
        return this.exceptionHandlerServices != null ? this.exceptionHandlerServices.length : 0;
    }

    public void transfer(JoinPoint thisJoinPoint, Exception exception) throws Exception {
        LOGGER.debug("execute ExceptionTransfer.transfer ");
        Class<?> clazz = thisJoinPoint.getTarget().getClass();
        Signature signature = thisJoinPoint.getSignature();
        Locale locale = LocaleContextHolder.getLocale();
        if (exception instanceof EgovBizException) {
            LOGGER.debug("Exception case :: EgovBizException ");
            EgovBizException be = (EgovBizException)exception;
            if (be.getWrappedException() != null) {
                Throwable throwable = be.getWrappedException();
                this.getLog(clazz).error(be.getMessage(), throwable);
            } else {
                this.getLog(clazz).error(be.getMessage(), be.getCause());
            }
            this.processHandling(clazz, signature.getName(), be, this.pm, this.exceptionHandlerServices);
            throw be;
        }
        if (exception instanceof RuntimeException) {
            LOGGER.debug("RuntimeException case :: RuntimeException ");
            RuntimeException be = (RuntimeException)exception;
            this.getLog(clazz).error(be.getMessage(), be.getCause());
            this.processHandling(clazz, signature.getName(), exception, this.pm, this.exceptionHandlerServices);
            if (be instanceof DataAccessException) {
                LOGGER.debug("RuntimeException case :: DataAccessException ");
                DataAccessException sqlEx = (DataAccessException)be;
                throw sqlEx;
            }
            throw be;
        }
        if (exception instanceof FdlException) {
            LOGGER.debug("FdlException case :: FdlException ");
            FdlException fe = (FdlException)exception;
            this.getLog(clazz).error(fe.getMessage(), fe.getCause());
            throw fe;
        }
        LOGGER.debug("case :: Exception ");
        this.getLog(clazz).error(exception.getMessage(), exception.getCause());
        throw this.processException(clazz, "fail.common.msg", new String[0], exception, locale);
    }

    protected Logger getLog(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    protected Exception processException(Class<?> clazz, String msgKey, String[] msgArgs, Exception e, Locale locale) {
        return this.processException(clazz, msgKey, msgArgs, e, locale, null);
    }

    protected Exception processException(Class<?> clazz, final String msgKey, final String[] msgArgs, final Exception e, final Locale locale, ExceptionCreator ec) {
        this.getLog(clazz).error(this.messageSource.getMessage(msgKey, (Object[])msgArgs, locale), (Throwable)e);
        ExceptionCreator exceptionCreator = null;
        exceptionCreator = ec == null ? new ExceptionCreator(){

            @Override
            public Exception processException(MessageSource messageSource) {
                return new BaseException(messageSource, msgKey, (Object[])msgArgs, locale, (Throwable)e);
            }
        } : ec;
        return exceptionCreator.processException(this.messageSource);
    }

    protected void processHandling(Class<?> clazz, String methodName, Exception exception, PathMatcher pm, ExceptionHandlerService[] exceptionHandlerServices) {
        for (ExceptionHandlerService ehm : exceptionHandlerServices) {
            try {
                if (!ehm.hasReqExpMatcher()) {
                    ehm.setReqExpMatcher(pm);
                }
                ehm.setPackageName(clazz.getCanonicalName() + "." + methodName);
                ehm.run(exception);
            }
            catch (Exception e) {
                LOGGER.error("ExceptionHandlerService Error", (Throwable)e);
            }
        }
    }

    protected static interface ExceptionCreator {
        public Exception processException(MessageSource var1);
    }
}

