/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.config.internal;

import egovframework.rte.fdl.logging.util.EgovJdkLogger;
import egovframework.rte.fdl.security.config.SecurityConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class MapClassFactoryBean
implements FactoryBean<String>,
ApplicationContextAware {
    private ApplicationContext context;
    private String defaultMapClass;

    public String getObject() throws Exception {
        try {
            SecurityConfig config = (SecurityConfig)this.context.getBean(SecurityConfig.class);
            if (StringUtils.hasText((String)config.getJdbcMapClass())) {
                return config.getJdbcMapClass();
            }
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            EgovJdkLogger.ignore((String)"There is no SecurityConfig.class.");
        }
        return this.defaultMapClass;
    }

    public Class<String> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public String getDefaultMapClass() {
        return this.defaultMapClass;
    }

    @Required
    public void setDefaultMapClass(String defaultMapClass) {
        this.defaultMapClass = defaultMapClass;
    }
}

