/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import egovframework.rte.fdl.security.securedobject.EgovSecuredObjectService;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.util.UrlMatcher;

public class EgovReloadableDefaultFilterInvocationDefinitionSource
extends DefaultFilterInvocationDefinitionSource
implements ApplicationContextAware {
    private MessageSource messageSource;
    private EgovSecuredObjectService securedObjectService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setSecuredObjectService(EgovSecuredObjectService securedObjectService) {
        this.securedObjectService = securedObjectService;
    }

    public EgovReloadableDefaultFilterInvocationDefinitionSource(UrlMatcher urlMatcher, LinkedHashMap requestMap) {
        super(urlMatcher, requestMap);
    }

    public void reloadRequestMap() throws Exception {
        try {
            LinkedHashMap reloadedMap = this.securedObjectService.getRolesAndUrl();
            Iterator iterator = reloadedMap.entrySet().iterator();
            Map mapToUse = this.getRequestMap();
            mapToUse.clear();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                RequestKey reqKey = (RequestKey)entry.getKey();
                this.addSecureUrl(reqKey.getUrl(), reqKey.getMethod(), (ConfigAttributeDefinition)entry.getValue());
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Secured Url Resources - Role Mappings reloaded at Runtime!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)this.getMessageSource().getMessage("error.security.runtime.error", new Object[]{"Reload RequestMap"}, Locale.getDefault()), (Throwable)e);
            if (e instanceof Exception) {
                throw e;
            }
            throw new Exception(e);
        }
    }

    void addSecureUrl(String pattern, String method, ConfigAttributeDefinition attr) {
        Map mapToUse = this.getRequestMap();
        mapToUse.put(this.getUrlMatcher().compile(pattern), attr);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added URL pattern: " + pattern + "; attributes: " + attr + (method == null ? "" : " for HTTP method '" + method + "'")));
        }
    }
}

