/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert;

public class ConversionException
extends RuntimeException {
    private Class sourceClass;
    private Class targetClass;
    private transient Object value;

    public ConversionException(Object value, Class targetClass, Throwable cause) {
        super("Unable to convert value '" + value + "' of type '" + (value != null ? value.getClass().getName() : null) + "' to class '" + targetClass.getName() + "'", cause);
        this.value = value;
        this.targetClass = targetClass;
    }

    public ConversionException(Class sourceClass, Object value, Class targetClass, String message, Throwable cause) {
        super(message, cause);
        this.sourceClass = sourceClass;
        this.value = value;
        this.targetClass = targetClass;
    }

    public ConversionException(Class sourceClass, Class targetClass, String message) {
        super(message);
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Object getValue() {
        return this.value;
    }
}

