/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import org.springframework.binding.convert.converters.AbstractConverter;
import org.springframework.util.StringUtils;

public class TextToBoolean
extends AbstractConverter {
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private static final String VALUE_ON = "on";
    private static final String VALUE_OFF = "off";
    private static final String VALUE_YES = "yes";
    private static final String VALUE_NO = "no";
    private static final String VALUE_1 = "1";
    private static final String VALUE_0 = "0";
    private String trueString;
    private String falseString;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TextToBoolean() {
        this(null, null);
    }

    public TextToBoolean(String trueString, String falseString) {
        this.trueString = trueString;
        this.falseString = falseString;
    }

    public Class[] getSourceClasses() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public Class[] getTargetClasses() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    protected Object doConvert(Object source, Class targetClass, Object context) throws Exception {
        String text = (String)source;
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        if (this.trueString != null && text.equalsIgnoreCase(this.trueString)) {
            return Boolean.TRUE;
        }
        if (this.falseString != null && text.equalsIgnoreCase(this.falseString)) {
            return Boolean.FALSE;
        }
        if (this.trueString == null && (text.equalsIgnoreCase(VALUE_TRUE) || text.equalsIgnoreCase(VALUE_ON) || text.equalsIgnoreCase(VALUE_YES) || text.equals(VALUE_1))) {
            return Boolean.TRUE;
        }
        if (this.falseString == null && (text.equalsIgnoreCase(VALUE_FALSE) || text.equalsIgnoreCase(VALUE_OFF) || text.equalsIgnoreCase(VALUE_NO) || text.equals(VALUE_0))) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
    }
}

