/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import javax.el.ExpressionFactory;
import org.springframework.util.ClassUtils;

public class DefaultExpressionFactoryUtils {
    private static final String DEFAULT_EXPRESSION_FACTORY = "org.jboss.el.ExpressionFactoryImpl";

    public static String getDefaultExpressionFactoryClassName() {
        return DEFAULT_EXPRESSION_FACTORY;
    }

    public static ExpressionFactory createExpressionFactory() throws IllegalStateException {
        Class expressionFactoryClass;
        try {
            expressionFactoryClass = ClassUtils.forName((String)DefaultExpressionFactoryUtils.getDefaultExpressionFactoryClassName());
        }
        catch (ClassNotFoundException e) {
            IllegalStateException ise = new IllegalStateException("The default ExpressionFactory class '" + DefaultExpressionFactoryUtils.getDefaultExpressionFactoryClassName() + "' could not be found in the classpath.  " + "Please add this to your classpath or set the default ExpressionFactory class name to something that is in the classpath.");
            ise.initCause(e);
            throw ise;
        }
        catch (NoClassDefFoundError e) {
            IllegalStateException ise = new IllegalStateException("The default ExpressionFactory class '" + DefaultExpressionFactoryUtils.getDefaultExpressionFactoryClassName() + "' could not be found in the classpath.  " + "Please add this to your classpath or set the default ExpressionFactory class name to something that is in the classpath.");
            ise.initCause(e);
            throw ise;
        }
        try {
            return (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("An instance of the default ExpressionFactory '" + DefaultExpressionFactoryUtils.getDefaultExpressionFactoryClassName() + "' could not be instantiated.  Check your EL implementation configuration.");
            ise.initCause(e);
            throw ise;
        }
    }
}

