/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.springframework.binding.expression.EvaluationAttempt;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.SetValueAttempt;
import org.springframework.binding.expression.el.ELContextFactory;
import org.springframework.util.Assert;

public class ELExpression
implements Expression {
    private ELContextFactory elContextFactory;
    private ValueExpression valueExpression;
    private boolean template;

    public ELExpression(ELContextFactory factory, ValueExpression valueExpression, boolean template) {
        Assert.notNull((Object)factory, (String)"The ELContextFactory is required to evaluate EL expressions");
        Assert.notNull((Object)valueExpression, (String)"The EL value expression is required for evaluation");
        this.elContextFactory = factory;
        this.valueExpression = valueExpression;
        this.template = template;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(Object context) throws EvaluationException {
        block4: {
            ELContext ctx = this.elContextFactory.getELContext(context);
            Object result = this.valueExpression.getValue(ctx);
            if (result != null || ctx.isPropertyResolved()) return result;
            if (!this.getExpressionString().equals("null")) break block4;
            return null;
        }
        try {
            EvaluationAttempt attempt = new EvaluationAttempt(this, context);
            throw new EvaluationException(attempt, attempt + " failed: the expression path did not resolve--is the base variable spelled correctly?", null);
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(new EvaluationAttempt(this, context), (Throwable)e);
        }
        catch (ELException e) {
            throw new EvaluationException(new EvaluationAttempt(this, context), (Throwable)e);
        }
    }

    public void setValue(Object context, Object value) throws EvaluationException {
        ELContext ctx = this.elContextFactory.getELContext(context);
        try {
            this.valueExpression.setValue(ctx, value);
            if (!ctx.isPropertyResolved()) {
                SetValueAttempt attempt = new SetValueAttempt(this, context, value);
                throw new EvaluationException(attempt, attempt + " failed: the expression path did not resolve--is the base variable incorrect?", null);
            }
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(new EvaluationAttempt(this, context), (Throwable)e);
        }
        catch (ELException ex) {
            throw new EvaluationException(new EvaluationAttempt(this, context), (Throwable)ex);
        }
    }

    public Class getValueType(Object context) {
        ELContext ctx = this.elContextFactory.getELContext(context);
        try {
            return this.valueExpression.getType(ctx);
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(new EvaluationAttempt(this, context), (Throwable)e);
        }
        catch (ELException ex) {
            throw new EvaluationException(new EvaluationAttempt(this, context), (Throwable)ex);
        }
    }

    public String getExpressionString() {
        if (this.template) {
            return this.valueExpression.getExpressionString();
        }
        String rawExpressionString = this.valueExpression.getExpressionString();
        return rawExpressionString.substring("#{".length(), rawExpressionString.length() - 1);
    }

    public int hashCode() {
        return this.valueExpression.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ELExpression)) {
            return false;
        }
        ELExpression other = (ELExpression)o;
        return this.valueExpression.equals((Object)other.valueExpression);
    }

    public String toString() {
        return this.valueExpression.getExpressionString();
    }
}

