/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.ognl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.binding.expression.EvaluationAttempt;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.SetValueAttempt;

class OgnlExpression
implements Expression {
    private Object expression;
    private Map variableExpressions;
    private Class expectedResultType;
    private String expressionString;

    public OgnlExpression(Object expression, Map variableExpressions, Class expectedResultType, String expressionString) {
        this.expression = expression;
        this.variableExpressions = variableExpressions;
        this.expectedResultType = expectedResultType;
        this.expressionString = expressionString;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OgnlExpression)) {
            return false;
        }
        OgnlExpression other = (OgnlExpression)o;
        return this.expressionString.equals(other.expressionString);
    }

    public int hashCode() {
        return this.expressionString.hashCode();
    }

    public Object getValue(Object context) throws EvaluationException {
        try {
            Map evaluationContext = Ognl.addDefaultContext((Object)context, (Map)this.getVariables(context));
            return Ognl.getValue((Object)this.expression, (Map)evaluationContext, (Object)context, (Class)this.expectedResultType);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyNotFoundException(new EvaluationAttempt(this, context), (Throwable)e);
        }
        catch (OgnlException e) {
            throw new EvaluationException(new EvaluationAttempt(this, context), (Throwable)e);
        }
    }

    public void setValue(Object context, Object value) {
        try {
            Map evaluationContext = Ognl.addDefaultContext((Object)context, (Map)this.getVariables(context));
            Ognl.setValue((Object)this.expression, (Map)evaluationContext, (Object)context, (Object)value);
        }
        catch (NoSuchPropertyException e) {
            throw new PropertyNotFoundException(new SetValueAttempt(this, context, value), (Throwable)e);
        }
        catch (OgnlException e) {
            throw new EvaluationException(new SetValueAttempt(this, context, value), (Throwable)e);
        }
    }

    public Class getValueType(Object context) {
        try {
            return new BeanWrapperImpl(context).getPropertyDescriptor(this.expressionString).getPropertyType();
        }
        catch (BeansException e) {
            throw new EvaluationException(new EvaluationAttempt(this, context), (Throwable)e);
        }
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    private Map getVariables(Object context) {
        if (this.variableExpressions == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap variables = new HashMap(this.variableExpressions.size(), 1.0f);
        Iterator it = this.variableExpressions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry var = it.next();
            Expression valueExpression = (Expression)var.getValue();
            variables.put(var.getKey(), valueExpression.getValue(context));
        }
        return variables;
    }

    public String toString() {
        return this.expression.toString();
    }
}

