/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.formatters;

import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.InvalidFormatException;
import org.springframework.util.StringUtils;

public class BooleanFormatter
implements Formatter {
    public String format(Object value) throws IllegalArgumentException {
        if (value == null) {
            return "";
        }
        if (Boolean.TRUE.equals(value)) {
            return "true";
        }
        if (Boolean.FALSE.equals(value)) {
            return "false";
        }
        throw new IllegalArgumentException("Must be a Boolean " + value);
    }

    public Object parse(String formattedString) throws InvalidFormatException {
        String string = formattedString = formattedString != null ? formattedString.trim() : null;
        if (!StringUtils.hasText((String)formattedString)) {
            return null;
        }
        if (formattedString.equals("true")) {
            return Boolean.TRUE;
        }
        if (formattedString.equals("false")) {
            return Boolean.FALSE;
        }
        throw new InvalidFormatException(formattedString, "true | false");
    }
}

