/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.format.formatters;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.springframework.binding.format.Formatter;
import org.springframework.binding.format.InvalidFormatException;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class NumberFormatter
implements Formatter {
    private String pattern;
    private Class numberClass;

    public NumberFormatter(Class numberClass) {
        Assert.notNull((Object)numberClass, (String)"The number class is required");
        this.numberClass = numberClass;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String format(Object number) {
        if (number == null) {
            return "";
        }
        if (this.pattern != null) {
            return this.getNumberFormat().format(number);
        }
        return number.toString();
    }

    public Object parse(String formattedString) throws InvalidFormatException {
        if (!StringUtils.hasText((String)formattedString)) {
            return null;
        }
        if (this.pattern != null) {
            return NumberUtils.parseNumber((String)formattedString, (Class)this.numberClass, (NumberFormat)this.getNumberFormat());
        }
        return NumberUtils.parseNumber((String)formattedString, (Class)this.numberClass);
    }

    private NumberFormat getNumberFormat() {
        return new DecimalFormat(this.pattern);
    }
}

