/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.impl.DefaultMappingResults;
import org.springframework.binding.mapping.results.RequiredError;
import org.springframework.binding.mapping.results.SourceAccessError;
import org.springframework.binding.mapping.results.Success;
import org.springframework.binding.mapping.results.TargetAccessError;
import org.springframework.binding.mapping.results.TypeConversionError;

public class DefaultMappingContext {
    private static final Log logger;
    private Object source;
    private Object target;
    private Mapping currentMapping;
    private List mappingResults;
    private ConversionService conversionService;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.binding.mapping.impl.DefaultMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public DefaultMappingContext(Object source, Object target, ConversionService conversionService) {
        this.source = source;
        this.target = target;
        this.conversionService = conversionService;
        this.mappingResults = new ArrayList();
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public Mapping getCurrentMapping() {
        return this.currentMapping;
    }

    public void setCurrentMapping(Mapping mapping) {
        if (this.currentMapping != null) {
            throw new IllegalStateException("The current mapping has not finished yet");
        }
        this.currentMapping = mapping;
    }

    public void setSuccessResult(Object originalValue, Object mappedValue) {
        this.add(new MappingResult(this.currentMapping, new Success(mappedValue, originalValue)));
    }

    public void setRequiredErrorResult(Object originalValue) {
        this.add(new MappingResult(this.currentMapping, new RequiredError(originalValue)));
    }

    public void setTypeConversionErrorResult(Object originalValue, Class targetType) {
        this.add(new MappingResult(this.currentMapping, new TypeConversionError(originalValue, targetType)));
    }

    public void setSourceAccessError(EvaluationException error) {
        this.add(new MappingResult(this.currentMapping, new SourceAccessError(error)));
    }

    public void setTargetAccessError(Object originalValue, EvaluationException error) {
        this.add(new MappingResult(this.currentMapping, new TargetAccessError(originalValue, error)));
    }

    public MappingResults toResult() {
        return new DefaultMappingResults(this.source, this.target, this.mappingResults);
    }

    private void add(MappingResult result) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding " + result));
        }
        this.mappingResults.add(result);
        this.currentMapping = null;
    }
}

