/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.message;

import java.text.MessageFormat;
import java.util.Locale;
import org.springframework.binding.message.DefaultMessageContext;
import org.springframework.binding.message.MessageContextFactory;
import org.springframework.binding.message.StateManageableMessageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.AbstractMessageSource;

public class DefaultMessageContextFactory
implements MessageContextFactory {
    private MessageSource messageSource;

    public DefaultMessageContextFactory(MessageSource messageSource) {
        if (messageSource == null) {
            messageSource = new DefaultTextFallbackMessageSource();
        }
        this.messageSource = messageSource;
    }

    public StateManageableMessageContext createMessageContext() {
        return new DefaultMessageContext(this.messageSource);
    }

    private class DefaultTextFallbackMessageSource
    extends AbstractMessageSource {
        private DefaultTextFallbackMessageSource() {
        }

        protected MessageFormat resolveCode(String code, Locale locale) {
            return null;
        }
    }
}

